package documents

// EmailValidationEventParams is the structure that we send to pushy
type EmailValidationEventParams struct {
	Email       string `json:"email"`
	OpaqueID    string `json:"opaque_id"`
	Purpose     string `json:"purpose"`
	RecipientID string `json:"recipient_id,omitempty"`
	Locale      string `json:"locale"`
}

// EmailValidationSuccessEventParams is the structure that we send on validation success
type EmailValidationSuccessEventParams struct {
	Namespace string `json:"namespace"`
	Key       string `json:"key"`
	Email     string `json:"email"`
	Locale    string `json:"locale"`
}
