package models

import "time"

// VerificationStatus is an enum that represents the three states an email
// validation request can be in
type VerificationStatus int

const (
	// StatusPending -- the link hasn't been clicked on yet
	StatusPending VerificationStatus = iota
	// StatusVerified -- the link has been clicked on successfully
	StatusVerified
	// StatusRejected -- the email is known to be bad (e.g., something bounced)
	StatusRejected
)

// VerificationRequest holds all information pertaining to an email verification request
type VerificationRequest struct {
	Namespace string             `dynamodbav:"namespace"`
	Key       string             `dynamodbav:"key"`
	Email     string             `dynamodbav:"email"`
	OpaqueID  string             `dynamodbav:"opaque_id"`
	Status    VerificationStatus `dynamodbav:"status"`
	Created   time.Time          `dynamodbav:"created"`
	Modified  time.Time          `dynamodbav:"modified"`
	Locale    string             `dynamodbav:"locale"`

	// CompoundKey is a concatenation of the Namespace, Key, and Email fields,
	// used to effectively make a triple-field key for dynamo
	CompoundKey string `dynamodbav:"compound_key"`
}
