package models

import (
	"crypto/md5"
	"fmt"
)

const (
	// StatusPendingString represents the pending status
	StatusPendingString = "Pending"
	// StatusVerifiedString represents the verified status
	StatusVerifiedString = "Verified"
	// StatusRejectedString represents the rejected status
	StatusRejectedString = "Rejected"
)

// MakeCompoundKey builds the triple-compound key for dynamo
func MakeCompoundKey(namespace, id, email string) string {
	return namespace + "##" + id + "##" + email
}

// MakeOpaqueID provides a randomized opaque identifier for the given
// namespace, id, email triple.  It's used in the email link to avoid
// leaking anything
func MakeOpaqueID(namespace, id, email string) string {
	key := MakeCompoundKey(namespace, id, email)
	return fmt.Sprintf("%x", md5.Sum([]byte(key)))
}

// StatusString provides a human-readable representation of an
// email verification state.
func StatusString(state VerificationStatus) string {
	switch state {
	case StatusPending:
		return StatusPendingString
	case StatusVerified:
		return StatusVerifiedString
	case StatusRejected:
		return StatusRejectedString
	default:
		return fmt.Sprintf("Unknown verification state: %v", state)
	}
}
