package middleware

import (
	"net/http"

	"golang.org/x/net/context"
)

type key int

const (
	// fixes "should not use basic type string as key in context.WithValue"
	repositorySource key = iota
)

// Source is goji middleware that adds source to request contexts.
func Source() func(http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			setSource(r)
			h.ServeHTTP(w, r)
		})
	}
}

func setSource(r *http.Request) {
	source := r.Header.Get("Twitch-Repository")
	if source == "" {
		source = "unknown"
	}

	ctx := context.WithValue(r.Context(), repositorySource, source)
	*r = *r.WithContext(ctx)
}

// GetSource gets the source of the request from a context.
func GetSource(ctx context.Context) string {
	v := ctx.Value(repositorySource)
	if v == nil {
		return "unknown"
	}

	s, ok := v.(string)
	if !ok {
		return "unknown"
	}

	return s
}
