package publisher

import "time"

// Config specifies the variable settings for a Publisher
type Config struct {
	// Must be set
	RoleARN    string
	StreamName string
	// Has defaults
	AWSRegion       string
	RetryDelay      time.Duration
	RetryCount      int
	StatsSampleRate float32
}

const (
	defaultAWSRegion       = "us-west-2"
	defaultRetryDelay      = 100 * time.Millisecond
	defaultRetryCount      = 10
	defaultStatsSampleRate = 0.1
)

func (c *Config) awsRegion() string {
	if c.AWSRegion == "" {
		return defaultAWSRegion
	}
	return c.AWSRegion
}

func (c *Config) retryDelay() time.Duration {
	if c.RetryDelay == 0 {
		return defaultRetryDelay
	}
	return c.RetryDelay
}

func (c *Config) retryCount() int {
	if c.RetryCount == 0 {
		return defaultRetryCount
	}
	return c.RetryCount
}

func (c *Config) sampleRate() float32 {
	if c.StatsSampleRate == 0 {
		return defaultStatsSampleRate
	}
	return c.StatsSampleRate
}
