package rediser

import (
	"time"

	"github.com/go-redis/redis"
)

type delArgs struct {
	keys []string
	res  int64
}

type evalArgs struct {
	script string
	keys   []string
	args   []interface{}
	res    interface{}
}

type existsArgs struct {
	keys []string
	res  int64
}

type expireArgs struct {
	key string
	ttl time.Duration
	res bool
}

type getArgs struct {
	key string
	res string
}

type hDelArgs struct {
	key    string
	fields []string
	res    int64
}

type hGetAllArgs struct {
	key string
	res map[string]string
}

type hKeysArgs struct {
	key string
	res []string
}

type hMGetArgs struct {
	key    string
	fields []string
	res    []interface{}
}

type hMSetArgs struct {
	key    string
	fields map[string]interface{}
}

type hSetArgs struct {
	key   string
	field string
	val   interface{}
	res   bool
}

type hSetNXArgs struct {
	key   string
	field string
	val   interface{}
	res   bool
}

type hIncrByArgs struct {
	key   string
	field string
	val   int64
	res   int64
}

type hLenArgs struct {
	key string
	res int64
}

type incrArgs struct {
	key string
	res int64
}

type lLenArgs struct {
	key string
	res int64
}

type lRangeArgs struct {
	key   string
	start int64
	stop  int64
	res   []string
}

type lRemArgs struct {
	key   string
	count int64
	val   interface{}
	res   int64
}

type lTrimArgs struct {
	key   string
	start int64
	stop  int64
}

type mGetArgs struct {
	keys []string
	res  []interface{}
}

type mSetArgs struct {
	pairs []interface{}
}

type mSetTTLArgs struct {
	pairs []interface{}
	ttl   time.Duration
}

type pipelinedDelArgs struct {
	keys []string
	res  int64
}

type pipelinedGetArgs struct {
	keys []string
	res  []interface{}
}

type rPushArgs struct {
	key string
	val string
	res int64
}

type sAddArgs struct {
	key  string
	vals []interface{}
	res  int64
}

type sDiffArgs struct {
	keys []string
	res  []string
}

type setArgs struct {
	key string
	val string
	ttl time.Duration
}

type setNxArgs struct {
	key string
	val string
	ttl time.Duration
	res bool
}

type sIsMemberArgs struct {
	key string
	val interface{}
	res bool
}

type sMembersArgs struct {
	key string
	res []string
}

type sRemArgs struct {
	key  string
	vals []interface{}
	res  int64
}

type sScanArgs struct {
	key       string
	cursor    uint64
	match     string
	count     int64
	resCursor uint64
	res       []string
}

type ttlArgs struct {
	key string
	res time.Duration
}

type zAddArgs struct {
	key   string
	items []redis.Z
	res   int64
}

type zCardArgs struct {
	key string
	res int64
}

type zRangeByLexArgs struct {
	key string
	opt redis.ZRangeBy
	res []string
}

type zRangeByScoreArgs struct {
	key string
	opt redis.ZRangeBy
	res []string
}

type zRemArgs struct {
	key     string
	element string
	res     int64
}

type zRemRangeByScoreArgs struct {
	key string
	min string
	max string
	res int64
}

type zScoreArgs struct {
	key     string
	element string
	res     float64
}
