package rediser

import "github.com/go-redis/redis"

const (
	delCmd              = "del"
	evalCmd             = "eval"
	existsCmd           = "exists"
	expireCmd           = "expire"
	flushDbCmd          = "flushdb"
	getCmd              = "get"
	hDelCmd             = "hdel"
	hGetAllCmd          = "hgetall"
	hKeysCmd            = "hkeys"
	hMGetCmd            = "hmget"
	hMSetCmd            = "hmset"
	hSetCmd             = "hset"
	hSetNXCmd           = "hsetnx"
	hIncrByCmd          = "hincrby"
	hLenCmd             = "hlen"
	incrCmd             = "incr"
	lLenCmd             = "llen"
	lRangeCmd           = "lrange"
	lRemCmd             = "lrem"
	lTrimCmd            = "ltrim"
	mGetCmd             = "mget"
	mSetCmd             = "mset"
	mSetNxTTLCmd        = "msetnxttl"
	mSetTTLCmd          = "msetttl"
	pipelinedDelCmd     = "pipelineddel"
	pipelinedGetCmd     = "pipelinedget"
	rPushCmd            = "rpush"
	sAddCmd             = "sadd"
	sDiffCmd            = "sdiff"
	setCmd              = "set"
	setNxCmd            = "setnx"
	sIsMemberCmd        = "sismember"
	sMembersCmd         = "smembers"
	sRemCmd             = "srem"
	sScanCmd            = "sscan"
	ttlCmd              = "ttl"
	zAddCmd             = "zadd"
	zCardCmd            = "zcard"
	zRangeByLexCmd      = "zrangebylex"
	zRangeByScoreCmd    = "zrangebyscore"
	zRemCmd             = "zrem"
	zRemRangeByScoreCmd = "zremrangebyscore"
	zScoreCmd           = "zscore"

	successStr = "success"
	errorStr   = "error"

	// ErrRedisNil represents the "redis: nil" return value, which is returned in
	// various situations, such as requests for nonexistent keys.
	ErrRedisNil = redis.Nil
)
