package common

import "errors"

var (
	// ErrInvalidCommand is returned if the Redis client attempts to send an
	// invalid command
	ErrInvalidCommand = errors.New("invalid Redis command")
	// ErrInvalidRedisSetting is returned if the Redis client cannot be
	// instantiated due to an invalid setting
	ErrInvalidRedisSetting = errors.New("invalid Redis setting")
	// ErrInvalidArguments is returned if the Redis client returns values
	// which are not expected.
	ErrInvalidArguments = errors.New("invalid arguments returned")
)
