package common

import (
	"fmt"
	"log"

	"github.com/cactus/go-statsd-client/statsd"
	"github.com/go-redis/redis"
)

// ReportPoolStats using the provided statter and prefix to report gauge metrics for the fields in PoolStats.
func ReportPoolStats(statter statsd.Statter, prefix string, stats *redis.PoolStats) {
	// Number of requested connections
	if err := statter.Gauge(fmt.Sprintf("%s.connections.requests", prefix), int64(stats.Requests), 1); err != nil {
		log.Printf("failed to report statsd metric: %q", err)
	}
	// Number of free connections received
	if err := statter.Gauge(fmt.Sprintf("%s.connections.hits", prefix), int64(stats.Hits), 1); err != nil {
		log.Printf("failed to report statsd metric: %q", err)
	}
	// Number of wait timeouts encountered
	if err := statter.Gauge(fmt.Sprintf("%s.connections.timeouts", prefix), int64(stats.Timeouts), 1); err != nil {
		log.Printf("failed to report statsd metric: %q", err)
	}
	// Number of total connections in the pool
	if err := statter.Gauge(fmt.Sprintf("%s.connections.total_conns", prefix), int64(stats.TotalConns), 1); err != nil {
		log.Printf("failed to report statsd metric: %q", err)
	}
	// Number of free connections in the pool
	if err := statter.Gauge(fmt.Sprintf("%s.connections.free_conns", prefix), int64(stats.FreeConns), 1); err != nil {
		log.Printf("failed to report statsd metric: %q", err)
	}
}
