package common

import (
	"context"
	"time"

	"code.justin.tv/chat/timing"
)

// XactStart starts a timer from the given context or the current time.
func XactStart(ctx context.Context) (*timing.SubXact, time.Time) {
	xact, ok := timing.XactFromContext(ctx)
	if ok {
		sub := xact.Sub("redis")
		return sub, sub.Start()
	}
	return nil, time.Now()
}

// XactEnd returns the duration elapsed since an xact timer started.
func XactEnd(sub *timing.SubXact, startTime time.Time) time.Duration {
	if sub != nil {
		return sub.End()
	}
	return time.Since(startTime)
}
