package owl

import (
	"fmt"
)

// Error implements the error interface and represents an error from Owl's Client
type Error struct {
	Code    string
	Message string
}

func (e *Error) Error() string {
	return fmt.Sprintf("Invalid request, error code: %s, error description: %s", e.Code, e.Message)
}
