package owl

// Token enables accessing a successful response from Owl's authorize/ endpoint
type Token interface {
	AccessToken() string
	Code() string
	Scope() string
}

type tokenImpl struct {
	code        string
	accessToken string
	scope       string
}

func (tok *tokenImpl) AccessToken() string {
	return tok.accessToken
}

func (tok *tokenImpl) Code() string {
	return tok.code
}

func (tok *tokenImpl) Scope() string {
	return tok.scope
}
