// Code generated by protoc-gen-go. DO NOT EDIT.
// source: rpc/uploader/service.proto

/*
Package uploader is a generated protocol buffer package.

It is generated from these files:
	rpc/uploader/service.proto

It has these top-level messages:
	UploadRequest
	Output
	Transformation
	Crop
	MaxWidth
	MaxHeight
	AspectRatio
	Resize
	Transcode
	Dimensions
	Validation
	Constraint
	Callback
	Monitoring
	Permissions
	UploadResponse
	StatusRequest
	StatusResponse
	SetStatusRequest
	Empty
*/
package uploader

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Possible states an upload can be in.
type Status int32

const (
	// Create() has been called, but the file has not been updated yet.
	Status_REQUESTED Status = 0
	// A worker has picked up the job to postprocess the file.
	Status_POSTPROCESS_STARTED Status = 1
	// Postprocessing has completed and the callback has been made, waiting for the feature
	// service to call SetStatus(COMPLETE).
	Status_POSTPROCESS_COMPLETE Status = 2
	// The whole process is complete. Feature services should set this status when they are done
	// processing the callback and the whole process is complete. We will pubsub back to the client
	// to let them know their image is ready.
	Status_COMPLETE Status = 3
	// This status is deprecated and will not be set, see below
	Status_VALIDATION_FAILED Status = 4
	// This status is deprecated and will not be set, see below
	Status_POSTPROCESS_FAILED Status = 5
	// Postprocessing has failed and will be retried.
	Status_POSTPROCESS_RETRYING Status = 6
	// Feature services should set this status if there is a failure on their end that will not be retried.
	// We will pubsub back to the client that the failure happened. If you send a message along with your
	// SetStatusRequest, ensure that it is sanitized for displaying to a user.
	Status_FEATURE_SERVICE_FAILED Status = 7
	// An image is required but a non-image was uploaded. Triggered by validations or transformations
	Status_IS_IMAGE_VALIDATION_FAILED Status = 110
	// Aspect ratio validation failed. Aspect ratio did not follow constraints
	Status_ASPECT_RATIO_VALIDATION_FAILED Status = 111
	// Width validation failed. Width did not follow constraints
	Status_WIDTH_VALIDATION_FAILED Status = 112
	// Height validation failed. Height did not follow constraints
	Status_HEIGHT_VALIDATION_FAILED Status = 113
	// Image format validation failed. The file was an image of the wrong format
	Status_IMAGE_FORMAT_VALIDATION_FAILED Status = 114
	// File size validation failed. The file size was too large
	Status_FILE_SIZE_VALIDATION_FAILED Status = 120
	// Transformations on a valid image failed
	Status_TRANSFORMATION_FAILED Status = 210
	// The worker failed for reasons other than validations or transformations, including file I/O and AWS calls
	Status_PROCESSING_FAILED Status = 220
)

var Status_name = map[int32]string{
	0:   "REQUESTED",
	1:   "POSTPROCESS_STARTED",
	2:   "POSTPROCESS_COMPLETE",
	3:   "COMPLETE",
	4:   "VALIDATION_FAILED",
	5:   "POSTPROCESS_FAILED",
	6:   "POSTPROCESS_RETRYING",
	7:   "FEATURE_SERVICE_FAILED",
	110: "IS_IMAGE_VALIDATION_FAILED",
	111: "ASPECT_RATIO_VALIDATION_FAILED",
	112: "WIDTH_VALIDATION_FAILED",
	113: "HEIGHT_VALIDATION_FAILED",
	114: "IMAGE_FORMAT_VALIDATION_FAILED",
	120: "FILE_SIZE_VALIDATION_FAILED",
	210: "TRANSFORMATION_FAILED",
	220: "PROCESSING_FAILED",
}
var Status_value = map[string]int32{
	"REQUESTED":                      0,
	"POSTPROCESS_STARTED":            1,
	"POSTPROCESS_COMPLETE":           2,
	"COMPLETE":                       3,
	"VALIDATION_FAILED":              4,
	"POSTPROCESS_FAILED":             5,
	"POSTPROCESS_RETRYING":           6,
	"FEATURE_SERVICE_FAILED":         7,
	"IS_IMAGE_VALIDATION_FAILED":     110,
	"ASPECT_RATIO_VALIDATION_FAILED": 111,
	"WIDTH_VALIDATION_FAILED":        112,
	"HEIGHT_VALIDATION_FAILED":       113,
	"IMAGE_FORMAT_VALIDATION_FAILED": 114,
	"FILE_SIZE_VALIDATION_FAILED":    120,
	"TRANSFORMATION_FAILED":          210,
	"PROCESSING_FAILED":              220,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Tells ImageMagick to remove transparency information from the image,
// see http://www.imagemagick.org/Usage/masking/#alpha_remove.
// Used with Transcode message.
type RemoveAlpha int32

const (
	// Default behavior: TRUE if format = jp(e)g.
	RemoveAlpha_DEFAULT RemoveAlpha = 0
	// Do not remove alpha channel.
	RemoveAlpha_FALSE RemoveAlpha = 1
	// Remove alpha channel.
	RemoveAlpha_TRUE RemoveAlpha = 2
)

var RemoveAlpha_name = map[int32]string{
	0: "DEFAULT",
	1: "FALSE",
	2: "TRUE",
}
var RemoveAlpha_value = map[string]int32{
	"DEFAULT": 0,
	"FALSE":   1,
	"TRUE":    2,
}

func (x RemoveAlpha) String() string {
	return proto.EnumName(RemoveAlpha_name, int32(x))
}
func (RemoveAlpha) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type UploadRequest struct {
	// Defines one or more output files. At the very least, an output filename must be given so
	// we know where to put the file once it's been uploaded. Other things that can separate one
	// output from another are the transformations that are done to each one. For example, one
	// output may be the full-size image that was uploaded and another could be a smaller
	// thumbnail.
	Outputs []*Output `protobuf:"bytes,1,rep,name=outputs" json:"outputs,omitempty"`
	// PreValidations are run before any postprocessing happens. If an upload fails PreValidation
	// we won't even try to postprocess it.
	PreValidation *Validation `protobuf:"bytes,3,opt,name=pre_validation,json=preValidation" json:"pre_validation,omitempty"`
	// An S3 URL of the format s3://bucketname/path the caller wishes to upload the file to.
	OutputPrefix string `protobuf:"bytes,4,opt,name=output_prefix,json=outputPrefix" json:"output_prefix,omitempty"`
	// A description of the callback that the upload service should make when postprocessing is
	// complete.
	Callback *Callback `protobuf:"bytes,5,opt,name=callback" json:"callback,omitempty"`
	// Monitoring methods through which the feature service will receive information about this upload.
	// Supported methods are SNS, grafana, and rollbar. Grafana publishes timing information for both
	// success and failure, SNS and rollbar report error information on failure
	Monitoring *Monitoring `protobuf:"bytes,6,opt,name=monitoring" json:"monitoring,omitempty"`
}

func (m *UploadRequest) Reset()                    { *m = UploadRequest{} }
func (m *UploadRequest) String() string            { return proto.CompactTextString(m) }
func (*UploadRequest) ProtoMessage()               {}
func (*UploadRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *UploadRequest) GetOutputs() []*Output {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *UploadRequest) GetPreValidation() *Validation {
	if m != nil {
		return m.PreValidation
	}
	return nil
}

func (m *UploadRequest) GetOutputPrefix() string {
	if m != nil {
		return m.OutputPrefix
	}
	return ""
}

func (m *UploadRequest) GetCallback() *Callback {
	if m != nil {
		return m.Callback
	}
	return nil
}

func (m *UploadRequest) GetMonitoring() *Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

type Output struct {
	// Transformations are applied in order.
	Transformations []*Transformation `protobuf:"bytes,1,rep,name=transformations" json:"transformations,omitempty"`
	// PostValidation happens after all transformations are complete. If a PostValidation fails, the
	// file will not be moved out of the ingest bucket.
	PostValidation *Validation `protobuf:"bytes,2,opt,name=post_validation,json=postValidation" json:"post_validation,omitempty"`
	// Describes how to name this output file, especially useful in the case of multiple outputs.
	// If this is unset, the default is "{{UploadID}}".
	// Available templates:
	// - {{UploadID}}
	// - {{Extension}} given by the Transcode Validation or else empty.
	// - {{Dimensions}} applicable to images, available whether or not there is a resizing
	// transformation.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// Permissions determines the file permissions on the final upload. The default is to use the aws
	// "canned" acl "bucket-owner-full-control" to give the feature service full access to the file.
	// Bucket policies can be used to further control the permissions on the file. If this parameter
	// is nonempty, "bucket-owner-full-control" will not be used, and instead the feature service
	// should be explicity granted full control by setting GrantFullControl to "id=ACCOUNT_ID",
	// where ACCOUNT_ID is the Canonical User ID of the feature service's aws account
	Permissions *Permissions `protobuf:"bytes,4,opt,name=permissions" json:"permissions,omitempty"`
}

func (m *Output) Reset()                    { *m = Output{} }
func (m *Output) String() string            { return proto.CompactTextString(m) }
func (*Output) ProtoMessage()               {}
func (*Output) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Output) GetTransformations() []*Transformation {
	if m != nil {
		return m.Transformations
	}
	return nil
}

func (m *Output) GetPostValidation() *Validation {
	if m != nil {
		return m.PostValidation
	}
	return nil
}

func (m *Output) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Output) GetPermissions() *Permissions {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// There are several choices of transformation, this message may contain any one of those choices.
type Transformation struct {
	// Types that are valid to be assigned to Transformation:
	//	*Transformation_Crop
	//	*Transformation_MaxWidth
	//	*Transformation_MaxHeight
	//	*Transformation_AspectRatio
	//	*Transformation_Resize
	//	*Transformation_Transcode
	Transformation isTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (m *Transformation) Reset()                    { *m = Transformation{} }
func (m *Transformation) String() string            { return proto.CompactTextString(m) }
func (*Transformation) ProtoMessage()               {}
func (*Transformation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isTransformation_Transformation interface {
	isTransformation_Transformation()
}

type Transformation_Crop struct {
	Crop *Crop `protobuf:"bytes,1,opt,name=crop,oneof"`
}
type Transformation_MaxWidth struct {
	MaxWidth *MaxWidth `protobuf:"bytes,2,opt,name=max_width,json=maxWidth,oneof"`
}
type Transformation_MaxHeight struct {
	MaxHeight *MaxHeight `protobuf:"bytes,3,opt,name=max_height,json=maxHeight,oneof"`
}
type Transformation_AspectRatio struct {
	AspectRatio *AspectRatio `protobuf:"bytes,4,opt,name=aspect_ratio,json=aspectRatio,oneof"`
}
type Transformation_Resize struct {
	Resize *Resize `protobuf:"bytes,5,opt,name=resize,oneof"`
}
type Transformation_Transcode struct {
	Transcode *Transcode `protobuf:"bytes,6,opt,name=transcode,oneof"`
}

func (*Transformation_Crop) isTransformation_Transformation()        {}
func (*Transformation_MaxWidth) isTransformation_Transformation()    {}
func (*Transformation_MaxHeight) isTransformation_Transformation()   {}
func (*Transformation_AspectRatio) isTransformation_Transformation() {}
func (*Transformation_Resize) isTransformation_Transformation()      {}
func (*Transformation_Transcode) isTransformation_Transformation()   {}

func (m *Transformation) GetTransformation() isTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *Transformation) GetCrop() *Crop {
	if x, ok := m.GetTransformation().(*Transformation_Crop); ok {
		return x.Crop
	}
	return nil
}

func (m *Transformation) GetMaxWidth() *MaxWidth {
	if x, ok := m.GetTransformation().(*Transformation_MaxWidth); ok {
		return x.MaxWidth
	}
	return nil
}

func (m *Transformation) GetMaxHeight() *MaxHeight {
	if x, ok := m.GetTransformation().(*Transformation_MaxHeight); ok {
		return x.MaxHeight
	}
	return nil
}

func (m *Transformation) GetAspectRatio() *AspectRatio {
	if x, ok := m.GetTransformation().(*Transformation_AspectRatio); ok {
		return x.AspectRatio
	}
	return nil
}

func (m *Transformation) GetResize() *Resize {
	if x, ok := m.GetTransformation().(*Transformation_Resize); ok {
		return x.Resize
	}
	return nil
}

func (m *Transformation) GetTranscode() *Transcode {
	if x, ok := m.GetTransformation().(*Transformation_Transcode); ok {
		return x.Transcode
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Transformation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Transformation_OneofMarshaler, _Transformation_OneofUnmarshaler, _Transformation_OneofSizer, []interface{}{
		(*Transformation_Crop)(nil),
		(*Transformation_MaxWidth)(nil),
		(*Transformation_MaxHeight)(nil),
		(*Transformation_AspectRatio)(nil),
		(*Transformation_Resize)(nil),
		(*Transformation_Transcode)(nil),
	}
}

func _Transformation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Transformation)
	// transformation
	switch x := m.Transformation.(type) {
	case *Transformation_Crop:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Crop); err != nil {
			return err
		}
	case *Transformation_MaxWidth:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaxWidth); err != nil {
			return err
		}
	case *Transformation_MaxHeight:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaxHeight); err != nil {
			return err
		}
	case *Transformation_AspectRatio:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AspectRatio); err != nil {
			return err
		}
	case *Transformation_Resize:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Resize); err != nil {
			return err
		}
	case *Transformation_Transcode:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Transcode); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Transformation.Transformation has unexpected type %T", x)
	}
	return nil
}

func _Transformation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Transformation)
	switch tag {
	case 1: // transformation.crop
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Crop)
		err := b.DecodeMessage(msg)
		m.Transformation = &Transformation_Crop{msg}
		return true, err
	case 2: // transformation.max_width
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MaxWidth)
		err := b.DecodeMessage(msg)
		m.Transformation = &Transformation_MaxWidth{msg}
		return true, err
	case 3: // transformation.max_height
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MaxHeight)
		err := b.DecodeMessage(msg)
		m.Transformation = &Transformation_MaxHeight{msg}
		return true, err
	case 4: // transformation.aspect_ratio
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AspectRatio)
		err := b.DecodeMessage(msg)
		m.Transformation = &Transformation_AspectRatio{msg}
		return true, err
	case 5: // transformation.resize
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Resize)
		err := b.DecodeMessage(msg)
		m.Transformation = &Transformation_Resize{msg}
		return true, err
	case 6: // transformation.transcode
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Transcode)
		err := b.DecodeMessage(msg)
		m.Transformation = &Transformation_Transcode{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Transformation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Transformation)
	// transformation
	switch x := m.Transformation.(type) {
	case *Transformation_Crop:
		s := proto.Size(x.Crop)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Transformation_MaxWidth:
		s := proto.Size(x.MaxWidth)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Transformation_MaxHeight:
		s := proto.Size(x.MaxHeight)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Transformation_AspectRatio:
		s := proto.Size(x.AspectRatio)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Transformation_Resize:
		s := proto.Size(x.Resize)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Transformation_Transcode:
		s := proto.Size(x.Transcode)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Create a (width)x(height) image starting from the coordinates (left, top).
type Crop struct {
	Top    uint32 `protobuf:"varint,1,opt,name=top" json:"top,omitempty"`
	Left   uint32 `protobuf:"varint,2,opt,name=left" json:"left,omitempty"`
	Width  uint32 `protobuf:"varint,3,opt,name=width" json:"width,omitempty"`
	Height uint32 `protobuf:"varint,4,opt,name=height" json:"height,omitempty"`
}

func (m *Crop) Reset()                    { *m = Crop{} }
func (m *Crop) String() string            { return proto.CompactTextString(m) }
func (*Crop) ProtoMessage()               {}
func (*Crop) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Crop) GetTop() uint32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *Crop) GetLeft() uint32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *Crop) GetWidth() uint32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Crop) GetHeight() uint32 {
	if m != nil {
		return m.Height
	}
	return 0
}

// Take a (width)-wide slice from the center of an image without changing the height.
type MaxWidth struct {
	Width uint32 `protobuf:"varint,1,opt,name=width" json:"width,omitempty"`
}

func (m *MaxWidth) Reset()                    { *m = MaxWidth{} }
func (m *MaxWidth) String() string            { return proto.CompactTextString(m) }
func (*MaxWidth) ProtoMessage()               {}
func (*MaxWidth) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *MaxWidth) GetWidth() uint32 {
	if m != nil {
		return m.Width
	}
	return 0
}

// Take a (height)-tall slice from the center of an image without changing the width.
type MaxHeight struct {
	Height uint32 `protobuf:"varint,1,opt,name=height" json:"height,omitempty"`
}

func (m *MaxHeight) Reset()                    { *m = MaxHeight{} }
func (m *MaxHeight) String() string            { return proto.CompactTextString(m) }
func (*MaxHeight) ProtoMessage()               {}
func (*MaxHeight) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *MaxHeight) GetHeight() uint32 {
	if m != nil {
		return m.Height
	}
	return 0
}

// Force an image to have this aspect ratio (width/height).
type AspectRatio struct {
	Ratio float64 `protobuf:"fixed64,1,opt,name=ratio" json:"ratio,omitempty"`
}

func (m *AspectRatio) Reset()                    { *m = AspectRatio{} }
func (m *AspectRatio) String() string            { return proto.CompactTextString(m) }
func (*AspectRatio) ProtoMessage()               {}
func (*AspectRatio) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *AspectRatio) GetRatio() float64 {
	if m != nil {
		return m.Ratio
	}
	return 0
}

// Resize an image by specifying either an exact set of (width)x(height) Dimensions or as a
// percentage of the original size as an integer in [1-100]. The Dimensions resize ignores the
// original aspect ratio.
type Resize struct {
	// Types that are valid to be assigned to Size:
	//	*Resize_Dimensions
	//	*Resize_Percent
	Size isResize_Size `protobuf_oneof:"size"`
}

func (m *Resize) Reset()                    { *m = Resize{} }
func (m *Resize) String() string            { return proto.CompactTextString(m) }
func (*Resize) ProtoMessage()               {}
func (*Resize) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isResize_Size interface {
	isResize_Size()
}

type Resize_Dimensions struct {
	Dimensions *Dimensions `protobuf:"bytes,1,opt,name=dimensions,oneof"`
}
type Resize_Percent struct {
	Percent uint32 `protobuf:"varint,2,opt,name=percent,oneof"`
}

func (*Resize_Dimensions) isResize_Size() {}
func (*Resize_Percent) isResize_Size()    {}

func (m *Resize) GetSize() isResize_Size {
	if m != nil {
		return m.Size
	}
	return nil
}

func (m *Resize) GetDimensions() *Dimensions {
	if x, ok := m.GetSize().(*Resize_Dimensions); ok {
		return x.Dimensions
	}
	return nil
}

func (m *Resize) GetPercent() uint32 {
	if x, ok := m.GetSize().(*Resize_Percent); ok {
		return x.Percent
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Resize) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Resize_OneofMarshaler, _Resize_OneofUnmarshaler, _Resize_OneofSizer, []interface{}{
		(*Resize_Dimensions)(nil),
		(*Resize_Percent)(nil),
	}
}

func _Resize_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Resize)
	// size
	switch x := m.Size.(type) {
	case *Resize_Dimensions:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Dimensions); err != nil {
			return err
		}
	case *Resize_Percent:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Percent))
	case nil:
	default:
		return fmt.Errorf("Resize.Size has unexpected type %T", x)
	}
	return nil
}

func _Resize_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Resize)
	switch tag {
	case 1: // size.dimensions
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Dimensions)
		err := b.DecodeMessage(msg)
		m.Size = &Resize_Dimensions{msg}
		return true, err
	case 2: // size.percent
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Size = &Resize_Percent{uint32(x)}
		return true, err
	default:
		return false, nil
	}
}

func _Resize_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Resize)
	// size
	switch x := m.Size.(type) {
	case *Resize_Dimensions:
		s := proto.Size(x.Dimensions)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Resize_Percent:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Percent))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Transcode an image into the given format. Quality is only relevant for jpeg encoding and will
// be ignored for other types. No video postprocessing is currently supported.
// For images, "png" and "jpg" are the most commonly used formats, and "gif" for animations.
// We'll use the format as input to this https://www.imagemagick.org/script/formats.php.
type Transcode struct {
	Format      string      `protobuf:"bytes,1,opt,name=format" json:"format,omitempty"`
	Quality     uint32      `protobuf:"varint,2,opt,name=quality" json:"quality,omitempty"`
	RemoveAlpha RemoveAlpha `protobuf:"varint,3,opt,name=remove_alpha,json=removeAlpha,enum=code.justin.tv.web.upload_service.RemoveAlpha" json:"remove_alpha,omitempty"`
}

func (m *Transcode) Reset()                    { *m = Transcode{} }
func (m *Transcode) String() string            { return proto.CompactTextString(m) }
func (*Transcode) ProtoMessage()               {}
func (*Transcode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Transcode) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *Transcode) GetQuality() uint32 {
	if m != nil {
		return m.Quality
	}
	return 0
}

func (m *Transcode) GetRemoveAlpha() RemoveAlpha {
	if m != nil {
		return m.RemoveAlpha
	}
	return RemoveAlpha_DEFAULT
}

// (width)x(height) Dimensions used for Resize and Validation.
type Dimensions struct {
	Width  uint32 `protobuf:"varint,1,opt,name=width" json:"width,omitempty"`
	Height uint32 `protobuf:"varint,2,opt,name=height" json:"height,omitempty"`
}

func (m *Dimensions) Reset()                    { *m = Dimensions{} }
func (m *Dimensions) String() string            { return proto.CompactTextString(m) }
func (*Dimensions) ProtoMessage()               {}
func (*Dimensions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Dimensions) GetWidth() uint32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Dimensions) GetHeight() uint32 {
	if m != nil {
		return m.Height
	}
	return 0
}

// Since it doesn't make sense to have multiple types of the same validation, instead of
// repeating a oneof, add as many Validations to one message as are relevant.
type Validation struct {
	// File sizes can be specified with common suffixes like "1GB" or "3 mb". Case doesn't matter
	// and the letter 'B' always means bytes not bits. We will only process files smaller than 5GB.
	// File size limits larger than than this are illegal.
	// This limit change in the future if there is sufficient need.
	FileSizeLessThan string `protobuf:"bytes,1,opt,name=file_size_less_than,json=fileSizeLessThan" json:"file_size_less_than,omitempty"`
	// Image formats only. The string "image" will match all valid images.
	Format string `protobuf:"bytes,2,opt,name=format" json:"format,omitempty"`
	// Require an incoming image to have a particular aspect ratio (width/height).
	// This is a convenience parameter for aspect_ratio_constraint with equality.
	AspectRatio float64 `protobuf:"fixed64,3,opt,name=aspect_ratio,json=aspectRatio" json:"aspect_ratio,omitempty"`
	// Require an image to be larger than this size (inclusive).
	// This is a convenience parameter for width and height constraints with >=.
	MinimumSize *Dimensions `protobuf:"bytes,4,opt,name=minimum_size,json=minimumSize" json:"minimum_size,omitempty"`
	// Require an image to be smaller than this size (inclusive).
	// This is a convenience parameter for width and height constraints with <=.
	MaximumSize *Dimensions `protobuf:"bytes,5,opt,name=maximum_size,json=maximumSize" json:"maximum_size,omitempty"`
	// Numerical constraints on aspect ratio (width/height).
	AspectRatioConstraints []*Constraint `protobuf:"bytes,6,rep,name=aspect_ratio_constraints,json=aspectRatioConstraints" json:"aspect_ratio_constraints,omitempty"`
	// Numerical constraints on image width
	WidthConstraints []*Constraint `protobuf:"bytes,7,rep,name=width_constraints,json=widthConstraints" json:"width_constraints,omitempty"`
	// Numerical constraints on image height
	HeightConstraints []*Constraint `protobuf:"bytes,8,rep,name=height_constraints,json=heightConstraints" json:"height_constraints,omitempty"`
}

func (m *Validation) Reset()                    { *m = Validation{} }
func (m *Validation) String() string            { return proto.CompactTextString(m) }
func (*Validation) ProtoMessage()               {}
func (*Validation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Validation) GetFileSizeLessThan() string {
	if m != nil {
		return m.FileSizeLessThan
	}
	return ""
}

func (m *Validation) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *Validation) GetAspectRatio() float64 {
	if m != nil {
		return m.AspectRatio
	}
	return 0
}

func (m *Validation) GetMinimumSize() *Dimensions {
	if m != nil {
		return m.MinimumSize
	}
	return nil
}

func (m *Validation) GetMaximumSize() *Dimensions {
	if m != nil {
		return m.MaximumSize
	}
	return nil
}

func (m *Validation) GetAspectRatioConstraints() []*Constraint {
	if m != nil {
		return m.AspectRatioConstraints
	}
	return nil
}

func (m *Validation) GetWidthConstraints() []*Constraint {
	if m != nil {
		return m.WidthConstraints
	}
	return nil
}

func (m *Validation) GetHeightConstraints() []*Constraint {
	if m != nil {
		return m.HeightConstraints
	}
	return nil
}

// A constraint is a test on a single number: =, <, <=, >, >=
// All constraints must be satisfied. Specifying redundant or mutually exclusive constraints
// is illegal.
type Constraint struct {
	// The value to be tested against
	Value float64 `protobuf:"fixed64,1,opt,name=value" json:"value,omitempty"`
	// This string must be one of: =, <, <=, >, >=
	Test string `protobuf:"bytes,2,opt,name=test" json:"test,omitempty"`
}

func (m *Constraint) Reset()                    { *m = Constraint{} }
func (m *Constraint) String() string            { return proto.CompactTextString(m) }
func (*Constraint) ProtoMessage()               {}
func (*Constraint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *Constraint) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *Constraint) GetTest() string {
	if m != nil {
		return m.Test
	}
	return ""
}

// Describes the callback the upload service should make when postprocessing is complete.
type Callback struct {
	// The ARN of an SNS topic where the callback should be made.
	SnsTopicArn string `protobuf:"bytes,1,opt,name=sns_topic_arn,json=snsTopicArn" json:"sns_topic_arn,omitempty"`
	// Any data that should be included with the callback.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *Callback) Reset()                    { *m = Callback{} }
func (m *Callback) String() string            { return proto.CompactTextString(m) }
func (*Callback) ProtoMessage()               {}
func (*Callback) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *Callback) GetSnsTopicArn() string {
	if m != nil {
		return m.SnsTopicArn
	}
	return ""
}

func (m *Callback) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Customizes the monitoring of this upload.
type Monitoring struct {
	SnsTopic      string `protobuf:"bytes,1,opt,name=sns_topic,json=snsTopic" json:"sns_topic,omitempty"`
	GrafanaPrefix string `protobuf:"bytes,2,opt,name=grafana_prefix,json=grafanaPrefix" json:"grafana_prefix,omitempty"`
	RollbarToken  string `protobuf:"bytes,3,opt,name=rollbar_token,json=rollbarToken" json:"rollbar_token,omitempty"`
}

func (m *Monitoring) Reset()                    { *m = Monitoring{} }
func (m *Monitoring) String() string            { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()               {}
func (*Monitoring) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *Monitoring) GetSnsTopic() string {
	if m != nil {
		return m.SnsTopic
	}
	return ""
}

func (m *Monitoring) GetGrafanaPrefix() string {
	if m != nil {
		return m.GrafanaPrefix
	}
	return ""
}

func (m *Monitoring) GetRollbarToken() string {
	if m != nil {
		return m.RollbarToken
	}
	return ""
}

// Determines the explicit file permissions on the final upload. Default is the aws
// "canned" acl "bucket-owner-full-control". Syntax for these fields is the same as aws:
// they must start with 'id=' or 'uri=', whitespace is allowed, and multiple grantees can
// be specified using commas.
// For more information, visit http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
// For a syntax example, visit http://docs.aws.amazon.com/cli/latest/reference/s3api/put-object-acl.html#examples
type Permissions struct {
	// Grantee to be given full control. If this is set, it should be of the form:
	// "id=ACCOUNT_ID" where ACCOUNT_ID is the Canonical User ID of the feature service's aws account
	GrantFullControl string `protobuf:"bytes,1,opt,name=grant_full_control,json=grantFullControl" json:"grant_full_control,omitempty"`
	// Grantee to be given read permissions. To make the file publicly readable,
	// use the string: "uri=http://acs.amazonaws.com/groups/global/AllUsers"
	GrantRead string `protobuf:"bytes,2,opt,name=grant_read,json=grantRead" json:"grant_read,omitempty"`
}

func (m *Permissions) Reset()                    { *m = Permissions{} }
func (m *Permissions) String() string            { return proto.CompactTextString(m) }
func (*Permissions) ProtoMessage()               {}
func (*Permissions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *Permissions) GetGrantFullControl() string {
	if m != nil {
		return m.GrantFullControl
	}
	return ""
}

func (m *Permissions) GetGrantRead() string {
	if m != nil {
		return m.GrantRead
	}
	return ""
}

type UploadResponse struct {
	Url      string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	UploadId string `protobuf:"bytes,2,opt,name=upload_id,json=uploadId" json:"upload_id,omitempty"`
}

func (m *UploadResponse) Reset()                    { *m = UploadResponse{} }
func (m *UploadResponse) String() string            { return proto.CompactTextString(m) }
func (*UploadResponse) ProtoMessage()               {}
func (*UploadResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *UploadResponse) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *UploadResponse) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

type StatusRequest struct {
	// An ID from the URL returned by the call to Create
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId" json:"upload_id,omitempty"`
}

func (m *StatusRequest) Reset()                    { *m = StatusRequest{} }
func (m *StatusRequest) String() string            { return proto.CompactTextString(m) }
func (*StatusRequest) ProtoMessage()               {}
func (*StatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *StatusRequest) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

type StatusResponse struct {
	Status   Status `protobuf:"varint,1,opt,name=status,enum=code.justin.tv.web.upload_service.Status" json:"status,omitempty"`
	Message  string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	UploadId string `protobuf:"bytes,3,opt,name=upload_id,json=uploadId" json:"upload_id,omitempty"`
}

func (m *StatusResponse) Reset()                    { *m = StatusResponse{} }
func (m *StatusResponse) String() string            { return proto.CompactTextString(m) }
func (*StatusResponse) ProtoMessage()               {}
func (*StatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *StatusResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_REQUESTED
}

func (m *StatusResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *StatusResponse) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

type SetStatusRequest struct {
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId" json:"upload_id,omitempty"`
	Status   Status `protobuf:"varint,2,opt,name=status,enum=code.justin.tv.web.upload_service.Status" json:"status,omitempty"`
	Message  string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
}

func (m *SetStatusRequest) Reset()                    { *m = SetStatusRequest{} }
func (m *SetStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*SetStatusRequest) ProtoMessage()               {}
func (*SetStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *SetStatusRequest) GetUploadId() string {
	if m != nil {
		return m.UploadId
	}
	return ""
}

func (m *SetStatusRequest) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_REQUESTED
}

func (m *SetStatusRequest) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type Empty struct {
}

func (m *Empty) Reset()                    { *m = Empty{} }
func (m *Empty) String() string            { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()               {}
func (*Empty) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func init() {
	proto.RegisterType((*UploadRequest)(nil), "code.justin.tv.web.upload_service.UploadRequest")
	proto.RegisterType((*Output)(nil), "code.justin.tv.web.upload_service.Output")
	proto.RegisterType((*Transformation)(nil), "code.justin.tv.web.upload_service.Transformation")
	proto.RegisterType((*Crop)(nil), "code.justin.tv.web.upload_service.Crop")
	proto.RegisterType((*MaxWidth)(nil), "code.justin.tv.web.upload_service.MaxWidth")
	proto.RegisterType((*MaxHeight)(nil), "code.justin.tv.web.upload_service.MaxHeight")
	proto.RegisterType((*AspectRatio)(nil), "code.justin.tv.web.upload_service.AspectRatio")
	proto.RegisterType((*Resize)(nil), "code.justin.tv.web.upload_service.Resize")
	proto.RegisterType((*Transcode)(nil), "code.justin.tv.web.upload_service.Transcode")
	proto.RegisterType((*Dimensions)(nil), "code.justin.tv.web.upload_service.Dimensions")
	proto.RegisterType((*Validation)(nil), "code.justin.tv.web.upload_service.Validation")
	proto.RegisterType((*Constraint)(nil), "code.justin.tv.web.upload_service.Constraint")
	proto.RegisterType((*Callback)(nil), "code.justin.tv.web.upload_service.Callback")
	proto.RegisterType((*Monitoring)(nil), "code.justin.tv.web.upload_service.Monitoring")
	proto.RegisterType((*Permissions)(nil), "code.justin.tv.web.upload_service.Permissions")
	proto.RegisterType((*UploadResponse)(nil), "code.justin.tv.web.upload_service.UploadResponse")
	proto.RegisterType((*StatusRequest)(nil), "code.justin.tv.web.upload_service.StatusRequest")
	proto.RegisterType((*StatusResponse)(nil), "code.justin.tv.web.upload_service.StatusResponse")
	proto.RegisterType((*SetStatusRequest)(nil), "code.justin.tv.web.upload_service.SetStatusRequest")
	proto.RegisterType((*Empty)(nil), "code.justin.tv.web.upload_service.Empty")
	proto.RegisterEnum("code.justin.tv.web.upload_service.Status", Status_name, Status_value)
	proto.RegisterEnum("code.justin.tv.web.upload_service.RemoveAlpha", RemoveAlpha_name, RemoveAlpha_value)
}

func init() { proto.RegisterFile("rpc/uploader/service.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1401 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdf, 0x6e, 0xdb, 0xb6,
	0x1a, 0xf7, 0xbf, 0x38, 0xf6, 0xe7, 0xd8, 0x75, 0xd8, 0x36, 0x35, 0xd2, 0x73, 0x7a, 0x52, 0x05,
	0x07, 0x27, 0xa7, 0x4b, 0xdd, 0x7f, 0xc0, 0x2e, 0x06, 0x0c, 0x83, 0xe2, 0x28, 0xb1, 0x07, 0x27,
	0x71, 0x29, 0x25, 0xc5, 0xb2, 0x01, 0x02, 0x6b, 0x33, 0x89, 0x5a, 0x59, 0x52, 0x49, 0x3a, 0x4d,
	0x0b, 0xec, 0x05, 0x86, 0x5d, 0xec, 0x1d, 0xf6, 0x0c, 0xbb, 0xdc, 0x4b, 0x0c, 0xbb, 0xdc, 0xe5,
	0x80, 0xbd, 0xc6, 0x40, 0x8a, 0xb2, 0xe5, 0x2c, 0xc0, 0x94, 0x60, 0x77, 0xfc, 0x3e, 0xf2, 0xf7,
	0xfb, 0xfe, 0x93, 0x12, 0xac, 0xb2, 0x68, 0xf8, 0x64, 0x12, 0xf9, 0x21, 0x19, 0x51, 0xf6, 0x84,
	0x53, 0x76, 0xee, 0x0d, 0x69, 0x3b, 0x62, 0xa1, 0x08, 0xd1, 0xc3, 0x61, 0x38, 0xa2, 0xed, 0x37,
	0x13, 0x2e, 0xbc, 0xa0, 0x2d, 0xce, 0xdb, 0xef, 0xe9, 0xeb, 0x76, 0x7c, 0xd4, 0xd5, 0x07, 0x8d,
	0x3f, 0x0a, 0x50, 0x3f, 0x54, 0x2a, 0x4c, 0xdf, 0x4d, 0x28, 0x17, 0xa8, 0x03, 0x8b, 0xe1, 0x44,
	0x44, 0x13, 0xc1, 0x5b, 0xf9, 0xb5, 0xe2, 0x46, 0xed, 0xf9, 0xff, 0xdb, 0x7f, 0x4b, 0xd3, 0x3e,
	0x50, 0x08, 0x9c, 0x20, 0x91, 0x03, 0x8d, 0x88, 0x51, 0xf7, 0x9c, 0xf8, 0xde, 0x88, 0x08, 0x2f,
	0x0c, 0x5a, 0xc5, 0xb5, 0xfc, 0x46, 0xed, 0xf9, 0xe3, 0x0c, 0x5c, 0x47, 0x53, 0x10, 0xae, 0x47,
	0x8c, 0xce, 0x44, 0xb4, 0x0e, 0xf5, 0xd8, 0x80, 0x1b, 0x31, 0x7a, 0xe2, 0x5d, 0xb4, 0x4a, 0x6b,
	0xf9, 0x8d, 0x2a, 0x5e, 0x8a, 0x95, 0x03, 0xa5, 0x43, 0xbb, 0x50, 0x19, 0x12, 0xdf, 0x7f, 0x4d,
	0x86, 0x6f, 0x5b, 0x0b, 0xca, 0xe8, 0x27, 0x19, 0x8c, 0x76, 0x34, 0x04, 0x4f, 0xc1, 0x68, 0x0f,
	0x60, 0x1c, 0x06, 0x9e, 0x08, 0x99, 0x17, 0x9c, 0xb6, 0xca, 0x99, 0xfd, 0xdf, 0x9b, 0x82, 0x70,
	0x8a, 0xc0, 0xf8, 0xb1, 0x00, 0xe5, 0x38, 0x4d, 0xe8, 0x6b, 0xb8, 0x25, 0x18, 0x09, 0xf8, 0x49,
	0xc8, 0xc6, 0x2a, 0xb2, 0x24, 0xd5, 0xcf, 0x32, 0xd0, 0x3b, 0x73, 0x48, 0x7c, 0x99, 0x09, 0x1d,
	0xc1, 0xad, 0x28, 0xe4, 0x22, 0x9d, 0xfb, 0xc2, 0x4d, 0x72, 0xdf, 0x90, 0x2c, 0xa9, 0xe4, 0x23,
	0x28, 0x05, 0x64, 0x4c, 0x55, 0x21, 0xab, 0x58, 0xad, 0xd1, 0x00, 0x6a, 0x11, 0x65, 0x63, 0x8f,
	0x73, 0x15, 0x44, 0x49, 0xd9, 0x69, 0x67, 0xb0, 0x33, 0x98, 0xa1, 0x70, 0x9a, 0xc2, 0xf8, 0xbd,
	0x08, 0x8d, 0xf9, 0x08, 0xd1, 0xe7, 0x50, 0x1a, 0xb2, 0x30, 0x6a, 0xe5, 0x15, 0xfb, 0xff, 0xb2,
	0x14, 0x93, 0x85, 0x51, 0x37, 0x87, 0x15, 0x0c, 0x7d, 0x09, 0xd5, 0x31, 0xb9, 0x70, 0xdf, 0x7b,
	0x23, 0x71, 0xa6, 0x33, 0x91, 0xa5, 0x21, 0xf6, 0xc8, 0xc5, 0x2b, 0x09, 0xe9, 0xe6, 0x70, 0x65,
	0xac, 0xd7, 0xaa, 0x25, 0xc8, 0x85, 0x7b, 0x46, 0xbd, 0xd3, 0x33, 0xa1, 0x5b, 0x7a, 0x33, 0x1b,
	0x59, 0x57, 0x61, 0xba, 0x39, 0x2c, 0xbd, 0x89, 0x05, 0x64, 0xc3, 0x12, 0xe1, 0x11, 0x1d, 0x0a,
	0x97, 0xc9, 0x50, 0xaf, 0x91, 0x3f, 0x53, 0xc1, 0xb0, 0x44, 0x75, 0x73, 0xb8, 0x46, 0x66, 0x22,
	0xea, 0x40, 0x99, 0x51, 0xee, 0x7d, 0xa4, 0xba, 0xfb, 0xb3, 0x8c, 0x2f, 0x56, 0x80, 0x6e, 0x0e,
	0x6b, 0x28, 0xea, 0x43, 0x55, 0xf5, 0x95, 0x84, 0xea, 0xd6, 0xdf, 0xcc, 0xda, 0x9b, 0xf2, 0x98,
	0x8c, 0x73, 0x4a, 0xb0, 0xd5, 0x84, 0xc6, 0x7c, 0x97, 0x1a, 0xc7, 0x50, 0x92, 0x45, 0x42, 0x4d,
	0x28, 0x0a, 0x5d, 0xda, 0x3a, 0x96, 0x4b, 0xd9, 0x66, 0x3e, 0x3d, 0x11, 0xaa, 0x52, 0x75, 0xac,
	0xd6, 0xe8, 0x0e, 0x2c, 0xc4, 0xe5, 0x2b, 0x2a, 0x65, 0x2c, 0xa0, 0x15, 0x28, 0xeb, 0x42, 0x94,
	0x94, 0x5a, 0x4b, 0xc6, 0x1a, 0x54, 0x92, 0xe2, 0xcd, 0x90, 0xf9, 0x14, 0xd2, 0x58, 0x87, 0xea,
	0xb4, 0x22, 0x29, 0x9a, 0xfc, 0x1c, 0xcd, 0x3a, 0xd4, 0x52, 0x59, 0x96, 0x4c, 0x71, 0x91, 0xe4,
	0xa9, 0x3c, 0x8e, 0x05, 0xe3, 0x5b, 0x28, 0xc7, 0xb9, 0x43, 0x07, 0x00, 0x23, 0x6f, 0x4c, 0x03,
	0xae, 0xc7, 0x39, 0xeb, 0xc4, 0x6d, 0x4f, 0x41, 0xdd, 0x1c, 0x4e, 0x51, 0xa0, 0x55, 0x58, 0x8c,
	0x28, 0x1b, 0xd2, 0x40, 0xe7, 0xa2, 0x9b, 0xc3, 0x89, 0x62, 0xab, 0x0c, 0x25, 0x69, 0xd4, 0xf8,
	0x21, 0x0f, 0xd5, 0x69, 0xce, 0x65, 0x24, 0x71, 0x86, 0x95, 0xf9, 0x2a, 0xd6, 0x12, 0x6a, 0xc1,
	0xe2, 0xbb, 0x09, 0xf1, 0x3d, 0xf1, 0x41, 0x67, 0x35, 0x11, 0xd1, 0x4b, 0x58, 0x62, 0x74, 0x1c,
	0x9e, 0x53, 0x97, 0xf8, 0xd1, 0x19, 0x51, 0xf9, 0x6d, 0x64, 0x6a, 0x40, 0xac, 0x60, 0xa6, 0x44,
	0xe1, 0x1a, 0x9b, 0x09, 0xc6, 0x67, 0x00, 0xb3, 0x90, 0xae, 0xce, 0x7f, 0x2a, 0xe5, 0x85, 0xb9,
	0x94, 0xff, 0x5c, 0x02, 0x48, 0xdd, 0x38, 0x8f, 0xe1, 0xf6, 0x89, 0xe7, 0x53, 0x57, 0x86, 0xea,
	0xfa, 0x94, 0x73, 0x57, 0x9c, 0x91, 0x40, 0x07, 0xd7, 0x94, 0x5b, 0xb6, 0xf7, 0x91, 0xf6, 0x29,
	0xe7, 0xce, 0x19, 0x09, 0x52, 0xe1, 0x17, 0xe6, 0xc2, 0x7f, 0x78, 0x69, 0xca, 0x8a, 0xaa, 0x80,
	0x73, 0x33, 0x33, 0x80, 0xa5, 0xb1, 0x17, 0x78, 0xe3, 0xc9, 0x58, 0x19, 0xd3, 0x83, 0x78, 0xbd,
	0xf2, 0xe1, 0x9a, 0xa6, 0x90, 0x4e, 0x29, 0x46, 0x72, 0x31, 0x63, 0x5c, 0xb8, 0x19, 0x63, 0x4c,
	0xa1, 0x18, 0x4f, 0xa1, 0x95, 0x0e, 0xc3, 0x1d, 0x86, 0x01, 0x17, 0x8c, 0x78, 0x81, 0xe0, 0xad,
	0xb2, 0x7a, 0x3d, 0xb2, 0xb0, 0x77, 0xa6, 0x28, 0xbc, 0x92, 0xca, 0xc0, 0x4c, 0xcd, 0xd1, 0x31,
	0x2c, 0xab, 0x32, 0xcd, 0x59, 0x58, 0xbc, 0x89, 0x85, 0xa6, 0xe2, 0x49, 0x73, 0x7f, 0x03, 0x28,
	0xae, 0xf5, 0x1c, 0x79, 0xe5, 0x26, 0xe4, 0xcb, 0x31, 0x51, 0x8a, 0xdd, 0xf8, 0x14, 0x60, 0x26,
	0xca, 0xde, 0x3b, 0x27, 0xfe, 0x84, 0x26, 0x13, 0xab, 0x04, 0x79, 0xbf, 0x08, 0xca, 0x93, 0x1e,
	0x51, 0x6b, 0x63, 0x0b, 0x2a, 0xc9, 0xfb, 0x8f, 0x0c, 0xa8, 0xf3, 0x80, 0xbb, 0x22, 0x8c, 0xbc,
	0xa1, 0x4b, 0x58, 0xd2, 0x6e, 0x35, 0x1e, 0x70, 0x47, 0xea, 0x4c, 0xa6, 0x9e, 0xc2, 0x11, 0x11,
	0x44, 0x71, 0x2c, 0x61, 0xb5, 0x36, 0x26, 0x00, 0xb3, 0x87, 0x1f, 0xdd, 0x87, 0xea, 0x94, 0x45,
	0x33, 0x54, 0x12, 0x06, 0xf4, 0x5f, 0x68, 0x9c, 0x32, 0x72, 0x42, 0x02, 0x92, 0x7c, 0xc7, 0xc4,
	0xce, 0xd4, 0xb5, 0x56, 0x7f, 0xc8, 0xac, 0x43, 0x9d, 0x85, 0xd2, 0x2b, 0xe6, 0x8a, 0xf0, 0x2d,
	0x0d, 0xf4, 0xcb, 0xbb, 0xa4, 0x95, 0x8e, 0xd4, 0x19, 0xc7, 0x50, 0x4b, 0xbd, 0xa5, 0x68, 0x13,
	0xd0, 0x29, 0x23, 0x81, 0x70, 0x4f, 0x26, 0xbe, 0x2f, 0x73, 0x2c, 0x58, 0xe8, 0x27, 0x13, 0xa3,
	0x76, 0x76, 0x26, 0xbe, 0xdf, 0x89, 0xf5, 0xe8, 0xdf, 0x00, 0xf1, 0x69, 0x46, 0xc9, 0x48, 0x3b,
	0x51, 0x55, 0x1a, 0x4c, 0xc9, 0xc8, 0xf8, 0x02, 0x1a, 0xc9, 0xa7, 0x21, 0x8f, 0xc2, 0x80, 0x53,
	0x79, 0x5d, 0x4f, 0x58, 0xc2, 0x27, 0x97, 0x32, 0x50, 0x5d, 0x22, 0x2f, 0x61, 0xa8, 0xc4, 0x8a,
	0xde, 0xc8, 0xd8, 0x84, 0xba, 0x2d, 0x88, 0x98, 0xf0, 0xe4, 0xdb, 0x72, 0xee, 0x74, 0xfe, 0xd2,
	0xe9, 0xef, 0xf2, 0xd0, 0x48, 0x8e, 0x6b, 0x7b, 0x26, 0x94, 0xb9, 0xd2, 0xa8, 0xc3, 0x8d, 0x4c,
	0x6f, 0x99, 0xa6, 0xd0, 0x40, 0x79, 0xf9, 0x8d, 0x29, 0xe7, 0xe4, 0x94, 0x6a, 0xf7, 0x12, 0x71,
	0xde, 0x99, 0xe2, 0x25, 0x67, 0xbe, 0xcf, 0x43, 0xd3, 0xa6, 0x22, 0xbb, 0xfb, 0x29, 0x5f, 0x0b,
	0xff, 0x80, 0xaf, 0xc5, 0x39, 0x5f, 0x8d, 0x45, 0x58, 0xb0, 0xc6, 0x91, 0xf8, 0xf0, 0xe8, 0xa7,
	0x22, 0x94, 0x63, 0x14, 0xaa, 0x43, 0x15, 0x5b, 0x2f, 0x0f, 0x2d, 0xdb, 0xb1, 0xb6, 0x9b, 0x39,
	0x74, 0x0f, 0x6e, 0x0f, 0x0e, 0x6c, 0x67, 0x80, 0x0f, 0x3a, 0x96, 0x6d, 0xbb, 0xb6, 0x63, 0x62,
	0xb9, 0x91, 0x47, 0x2d, 0xb8, 0x93, 0xde, 0xe8, 0x1c, 0xec, 0x0d, 0xfa, 0x96, 0x63, 0x35, 0x0b,
	0x68, 0x09, 0x2a, 0x53, 0xa9, 0x88, 0xee, 0xc2, 0xf2, 0x91, 0xd9, 0xef, 0x6d, 0x9b, 0x4e, 0xef,
	0x60, 0xdf, 0xdd, 0x31, 0x7b, 0x7d, 0x6b, 0xbb, 0x59, 0x42, 0x2b, 0x80, 0xd2, 0x70, 0xad, 0x5f,
	0xb8, 0x4c, 0x8b, 0x2d, 0x07, 0x7f, 0xd5, 0xdb, 0xdf, 0x6d, 0x96, 0xd1, 0x2a, 0xac, 0xec, 0x58,
	0xa6, 0x73, 0x88, 0x2d, 0xd7, 0xb6, 0xf0, 0x51, 0xaf, 0x63, 0x25, 0xa8, 0x45, 0xf4, 0x00, 0x56,
	0x7b, 0xb6, 0xdb, 0xdb, 0x33, 0x77, 0x2d, 0xf7, 0xaf, 0xd6, 0x02, 0x64, 0xc0, 0x03, 0xd3, 0x1e,
	0x58, 0x1d, 0xc7, 0xc5, 0x72, 0xe7, 0x8a, 0x33, 0x21, 0xba, 0x0f, 0xf7, 0x5e, 0xf5, 0xb6, 0x9d,
	0xee, 0x15, 0x9b, 0x11, 0xfa, 0x17, 0xb4, 0xba, 0x56, 0x6f, 0xb7, 0xeb, 0x5c, 0xb1, 0xfb, 0x4e,
	0xd2, 0xc7, 0xb6, 0x77, 0x0e, 0xf0, 0x9e, 0x79, 0xd5, 0x19, 0x86, 0xfe, 0x03, 0xf7, 0x77, 0x7a,
	0x7d, 0xcb, 0xb5, 0x7b, 0xc7, 0x57, 0xf9, 0x78, 0x81, 0x56, 0xe1, 0xae, 0x83, 0xcd, 0x7d, 0x3b,
	0xe6, 0x48, 0x6d, 0xfd, 0x92, 0x47, 0x2b, 0xb0, 0xac, 0x33, 0xd2, 0xdb, 0xdf, 0x4d, 0xf4, 0xbf,
	0xe5, 0x1f, 0x3d, 0x81, 0x5a, 0xea, 0xc9, 0x44, 0x35, 0x58, 0xdc, 0xb6, 0x76, 0xcc, 0xc3, 0xbe,
	0xd3, 0xcc, 0xa1, 0x2a, 0x2c, 0xec, 0x98, 0x7d, 0xdb, 0x6a, 0xe6, 0x51, 0x05, 0x4a, 0x0e, 0x3e,
	0xb4, 0x9a, 0x85, 0xe7, 0xbf, 0x16, 0xa0, 0x72, 0xa8, 0x7f, 0xeb, 0xd0, 0x18, 0xca, 0x1d, 0x46,
	0x89, 0xa0, 0xe8, 0x69, 0x86, 0xae, 0x9a, 0xfb, 0x9f, 0x5b, 0x7d, 0x76, 0x0d, 0x84, 0x1e, 0xbb,
	0x37, 0x50, 0x9d, 0xf6, 0x3e, 0x7a, 0x91, 0xa5, 0x8f, 0x2f, 0x4d, 0xca, 0xea, 0x46, 0x06, 0x90,
	0x6a, 0x68, 0x19, 0x9a, 0x36, 0xf4, 0x34, 0xfb, 0xc0, 0x5c, 0x23, 0xb4, 0xf9, 0x1b, 0x65, 0x0b,
	0x8e, 0x2b, 0xc9, 0xcf, 0xf2, 0xeb, 0xb2, 0xfa, 0x4b, 0x7e, 0xf1, 0x67, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xf3, 0x39, 0x28, 0xa2, 0x43, 0x0f, 0x00, 0x00,
}
