package api

import (
	"code.justin.tv/common/config"
	"code.justin.tv/foundation/twitchserver"
	"code.justin.tv/identity/golibs/middleware"
	"code.justin.tv/web/users-service/internal/auth"
	"code.justin.tv/web/users-service/logic"
	"goji.io"
	"goji.io/pat"
)

type Server struct {
	*goji.Mux
	logic logic.Logic
	auth  auth.Decoder
}

func NewServer(logic logic.Logic, auth auth.Decoder) (*Server, error) {
	server := twitchserver.NewServer()

	server.Use(middleware.Source())
	server.Use(middleware.Stats(config.Statsd(), 0.1))

	s := &Server{
		server,
		logic,
		auth,
	}

	s.HandleFunc(pat.Get("/users/external"), CreateHandler(s.getPropertiesExternal))
	s.HandleFunc(pat.Get("/users/:id/external"), CreateHandler(s.getUserExternal))

	s.HandleFunc(pat.Get("/users"), CreateHandler(s.getProperties))
	s.HandleFunc(pat.Get("/users/:id"), CreateHandler(s.getUser))
	s.HandleFunc(pat.Get("/users/:id/rename_eligible"), CreateHandler(s.getRenameEligiblity))
	s.HandleFunc(pat.Put("/users/:id/ban"), CreateHandler(s.banUser))
	s.HandleFunc(pat.Patch("/users/:id"), CreateHandler(s.setProperties))
	s.HandleFunc(pat.Delete("/users/:id/ban"), CreateHandler(s.unbanUser))
	s.HandleFunc(pat.Post("/users/:id/verify_phone_number"), CreateHandler(s.phoneNumberCode))
	s.HandleFunc(pat.Get("/banned_users"), CreateHandler(s.getBannedUsers))
	s.HandleFunc(pat.Put("/users/:id/dmca_strike"), CreateHandler(s.addDMCAStrike))
	s.HandleFunc(pat.Delete("/users/:id/dmca_strike"), CreateHandler(s.removeDMCAStrike))
	s.HandleFunc(pat.Delete("/users/:id/cache"), CreateHandler(s.expireUserCache))
	s.HandleFunc(pat.Post("/users"), CreateHandler(s.createUser))
	s.HandleFunc(pat.Delete("/users/:id"), CreateHandler(s.deleteUser))
	s.HandleFunc(pat.Patch("/users/:id/undelete"), CreateHandler(s.undeleteUser))
	s.HandleFunc(pat.Get("/global_privileged_users"), CreateHandler(s.getGlobalPrivilegedUsers))
	s.HandleFunc(pat.Get("/logins"), CreateHandler(s.getLoginType))
	s.HandleFunc(pat.Patch("/users/editor/:id/images"), CreateHandler(s.setUserImagesAuthed))
	s.HandleFunc(pat.Patch("/users/:id/images"), CreateHandler(s.uploadUserImage))
	s.HandleFunc(pat.Patch("/users/:id/images/metadata"), CreateHandler(s.setUserImages))

	s.HandleFunc(pat.Get(`/channels`), CreateHandler(s.getChannelProperties))
	s.HandleFunc(pat.Patch(`/channels`), CreateHandler(s.setChannelProperties))
	s.HandleFunc(pat.Patch(`/channels/editor/:id`), CreateHandler(s.setChannelPropertiesExternal))

	s.HandleFunc(pat.Get(`/reservations`), CreateHandler(s.getReservations))
	s.HandleFunc(pat.Patch(`/reservations`), CreateHandler(s.updateReservation))
	s.HandleFunc(pat.Post(`/reservations`), CreateHandler(s.addReservation))
	s.HandleFunc(pat.Delete(`/reservations/:login`), CreateHandler(s.deleteReservation))

	return s, nil
}
