package api

import (
	"net/http"
	"net/url"
	"time"

	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

var ErrNoParameters = &models.CodedError{
	ErrorValue:      "Missing required parameters",
	CodeValue:       "missing_params",
	StatusCodeValue: http.StatusBadRequest,
}

var ErrBadParameters = &models.CodedError{
	ErrorValue:      "Invalid parameters in request",
	CodeValue:       "bad_params",
	StatusCodeValue: http.StatusBadRequest,
}

func (S *Server) getBannedUsers(ctx context.Context, values url.Values, r *http.Request) (interface{}, error) {

	// Grab the first "until=" parameter in the query string
	until := values.Get("until")

	if until == "" {
		return nil, ErrNoParameters
	}

	untilTime, err := time.Parse(time.RFC3339, until)
	if err != nil {
		return nil, ErrBadParameters
	}

	ups, err := S.logic.GetBannedUsers(ctx, untilTime)
	if err != nil {
		return nil, err
	}

	asID := values.Get("return_id_as_string") == "true"
	reportAsID(ctx, "banned_user", asID)
	if !asID {
		return UserPropertiesResult{Results: ups}.ConvertToIntIDPropertiesResult()
	}
	return &UserPropertiesResult{Results: ups}, nil
}
