package api

import (
	"encoding/json"
	"net/http"
	"net/url"

	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

func (S *Server) getPropertiesExternal(ctx context.Context, values url.Values, r *http.Request) (interface{}, error) {
	values.Add("return_id_as_string", "true")
	users, err := S.getProperties(ctx, values, r)
	if err != nil {
		return nil, err
	}

	requester := values.Get("requester")
	err = S.auth.AuthorizeBulkUserRead(ctx, r, requester)
	if err != nil {
		var decoded models.PropertiesResultExternal
		byteData, err := json.Marshal(users)
		if err != nil {
			return nil, err
		}

		err = json.Unmarshal(byteData, &decoded)
		if err != nil {
			return nil, err
		}

		return decoded, nil
	}
	return users, nil
}

func (S *Server) getUserExternal(ctx context.Context, values url.Values, r *http.Request) (interface{}, error) {
	values.Add("return_id_as_string", "true")
	user, err := S.getUser(ctx, values, r)
	if err != nil {
		return nil, err
	}

	requester := values.Get("requester")
	err = S.auth.AuthorizeUserRead(ctx, r, requester)
	if err != nil {
		var decoded models.PropertiesExternal
		byteData, err := json.Marshal(user)
		if err != nil {
			return nil, err
		}

		err = json.Unmarshal(byteData, &decoded)
		if err != nil {
			return nil, err
		}

		return decoded, nil
	}
	return user, nil
}
