package api

import (
	"net/http"
	"net/url"
	"strings"

	"code.justin.tv/web/users-service/models"

	"golang.org/x/net/context"
)

var validRoles = map[string]bool{
	"admin":      true,
	"subadmin":   true,
	"global_mod": true,
}

func (S *Server) getGlobalPrivilegedUsers(ctx context.Context, values url.Values, r *http.Request) (interface{}, error) {
	roles := values["role"]

	for idx, role := range roles {
		roles[idx] = strings.ToLower(role)
		if !validRoles[roles[idx]] {
			return nil, &models.ErrBadIdentifier{"role", role}
		}
	}

	upresult, err := S.logic.GetGlobalPrivilegedUsers(ctx, roles)
	if err != nil {
		return nil, err
	}

	return &upresult, nil
}
