package api

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"

	auth "code.justin.tv/web/users-service/internal/auth/mocks"
	"code.justin.tv/web/users-service/logic/mocks"
	"code.justin.tv/web/users-service/models"
)

func TestGlobalPrivilegedUsers(t *testing.T) {
	Convey("With a running API", t, func() {
		l := &mocks.Logic{}
		decoder := &auth.Decoder{}
		api, err := NewServer(l, decoder)
		So(err, ShouldBeNil)

		s := httptest.NewServer(api)
		defer s.Close()

		Convey("when /global_privileged_users is requested with invalid role", func() {
			invalidRole := "invalidrole"
			req, err := http.NewRequest("GET", fmt.Sprintf("%v/global_privileged_users?role=%v", s.URL, invalidRole), nil)
			So(err, ShouldBeNil)

			resp, err := http.DefaultClient.Do(req)
			So(err, ShouldBeNil)

			Convey("the response has HTTP status 400 Bad Request", func() {
				So(resp.Status, ShouldEqual, "400 Bad Request")
			})
		})

		Convey("when /global_privileged_users is requested with a valid role", func() {
			validRole := "subadmin"
			privilegedUsers := []models.GlobalPrivilegedUsers{{SubAdmins: []string{"abcd", "efgh"}}}
			l.On("GetGlobalPrivilegedUsers", Anything, []string{validRole}).Return(privilegedUsers, nil)

			req, err := http.NewRequest("GET", fmt.Sprintf("%v/global_privileged_users?role=%v", s.URL, validRole), nil)
			So(err, ShouldBeNil)

			resp, err := http.DefaultClient.Do(req)
			So(err, ShouldBeNil)

			Convey("the response has HTTP status 200 OK", func() {
				So(resp.Status, ShouldEqual, "200 OK")
			})

		})

	})

}
