package api

import (
	"encoding/json"
	"net/http"
	"net/url"

	"golang.org/x/net/context"

	"code.justin.tv/web/users-service/models"

	"goji.io/pat"
)

func (S *Server) phoneNumberCode(ctx context.Context, values url.Values, r *http.Request) (interface{}, error) {
	ID := pat.Param(r, "id")
	if !isValidID(ID) {
		return nil, models.ErrBadIdentifiers
	}

	props := &models.PhoneNumberCodeProperties{}

	decoder := json.NewDecoder(r.Body)
	err := decoder.Decode(props)
	if err != nil {
		return nil, errInvalidRequestBody
	}

	err = S.logic.VerifyPhoneNumber(ctx, ID, props.Code)
	return nil, err
}
