package api

import (
	"encoding/json"
	"net/http"
	"net/url"
	"strings"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
	"gopkg.in/validator.v2"
)

func (S *Server) createUser(ctx context.Context, values url.Values, r *http.Request) (interface{}, error) {
	upToCreate := &models.CreateUserProperties{}

	decoder := json.NewDecoder(r.Body)
	err := decoder.Decode(upToCreate)
	if err != nil {
		return nil, errx.New(errInvalidRequestBody)
	}

	if err := validator.Validate(upToCreate); err != nil {
		return nil, ErrNoParameters
	}

	upToCreate.Email = strings.ToLower(upToCreate.Email)
	if upToCreate.Language == "" {
		upToCreate.Language = "en"
	}
	if upToCreate.Category == "" {
		upToCreate.Category = "gaming"
	}

	return S.logic.CreateUser(ctx, upToCreate)
}
