package backend

import (
	"errors"

	"golang.org/x/net/context"

	"code.justin.tv/web/users-service/models"
)

//go:generate mockery -name Cacher
type Cacher interface {
	GetProperties(ctx context.Context, field string, key string, e interface{}) error
	ExpireProperties(ctx context.Context, prop models.Cacheable) error
	CacheProperties(ctx context.Context, overwrite bool, props models.Cacheable) error
	BulkGetProperties(ctx context.Context, field string, key []string, e interface{}) ([]int, error)
	BulkSetProperties(ctx context.Context, overwrite bool, iter models.CacheableIterator) error
	Close() error
}

var ErrCacheMiss = errors.New("key is missing")

func IsCacheMissErr(err error) bool {
	return ErrCacheMiss == err
}
