package channels_test

import (
	"reflect"
	"testing"

	"golang.org/x/net/context"

	"code.justin.tv/web/users-service/backend/channels"
	"code.justin.tv/web/users-service/backend/channels/mocks"
	"code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/models"
)

func TestHystrixBackend(t *testing.T) {
	t.Run("GetAllChannelPropertiesBulkSuccess", func(t *testing.T) {
		var ctx context.Context
		var channelIDs []uint64
		var channelNames []string
		var opts util.ReadOptions

		var expectedProps []models.ChannelProperties
		var expectedErr error

		m := &mocks.Backend{}
		m.On("GetAllChannelPropertiesBulk", ctx, channelIDs, channelNames, opts).Return(expectedProps, expectedErr)

		b := &channels.HystrixBackend{Backend: m}

		props, err := b.GetAllChannelPropertiesBulk(ctx, channelIDs, channelNames, opts)
		if !reflect.DeepEqual(props, expectedProps) {
			t.Errorf("props: expected is different from actual: %v != %v", expectedProps, props)
		}

		if !reflect.DeepEqual(err, expectedErr) {
			t.Errorf("err: expected is different from actual: %v != %v", expectedErr, err)
		}

		m.AssertExpectations(t)
	})
}
