package channels

import (
	"code.justin.tv/web/users-service/backend"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

func (c *channelPropertiesRepoImpl) UpdateChannelProperties(ctx context.Context, updateProps models.UpdateChannelProperties) (err error) {
	tx, err := backend.OpenTx(ctx, c.mdb, "update_channel_transaction")
	if err != nil {
		return err
	}
	defer func() {
		tx.Close(ctx, err)
	}()

	err = UpdateChannelUserProperties(ctx, updateProps, tx)
	if err != nil {
		return err
	}

	err = UpdateChannelAdProperties(ctx, updateProps, tx)
	if err != nil {
		return err
	}

	err = UpdateChannelBroadcastProperties(ctx, updateProps, tx)
	if err != nil {
		return err
	}

	err = UpdateChannelBasicProperties(ctx, updateProps, tx)
	if err != nil {
		return err
	}

	return nil
}

func (c *channelPropertiesRepoImpl) UpdateBasicChannelProperties(ctx context.Context, updateProps models.UpdateChannelProperties) (err error) {
	tx, err := backend.OpenTx(ctx, c.mdb, "update_basic_channel_transaction")
	if err != nil {
		return err
	}
	defer func() {
		tx.Close(ctx, err)
	}()

	err = UpdateChannelBasicProperties(ctx, updateProps, tx)
	if err != nil {
		return err
	}

	return nil
}
