package channels

import (
	"errors"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/database"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	SqlUpdateChannelAdProperties = `UPDATE "user_ad_properties" SET` +
		` "block_non_public_ads" = $2,` +
		` "prerolls_disabled" = $3,` +
		` "postrolls_disabled" = $4,` +
		` "fight_ad_block" = $5,` +
		` "updated_at" = LOCALTIMESTAMP` +
		` WHERE "user_id" = $1`

	SqlInsertChannelAdProperties = `INSERT into user_ad_properties (user_id, block_non_public_ads, prerolls_disabled, postrolls_disabled, fight_ad_block, created_at, updated_at)` +
		` VALUES ($1, $2, $3, $4, $5, LOCALTIMESTAMP, LOCALTIMESTAMP)`
)

func UpdateChannelAdProperties(ctx context.Context, updateProps models.UpdateChannelProperties, tx database.Tx) error {
	result, err := tx.Exec(
		ctx,
		"user_ad_properties_update",
		SqlUpdateChannelAdProperties,
		updateProps.ID,
		updateProps.BlockNonPublicAds,
		updateProps.PrerollsDisabled,
		updateProps.PostrollsDisabled,
		updateProps.FightAdBlock,
	)
	if err != nil {
		return errx.New(errors.New("Failed to exec channel_ad_properties_update"), errx.Fields{util.DBError: err})
	}

	affected, err := result.RowsAffected()
	if err != nil {
		return errx.New(err)
	}
	if affected == 0 {
		_, err := tx.Exec(
			ctx,
			"user_ad_properties_insert",
			SqlInsertChannelAdProperties,
			updateProps.ID,
			updateProps.BlockNonPublicAds,
			updateProps.PrerollsDisabled,
			updateProps.PostrollsDisabled,
			updateProps.FightAdBlock,
		)

		if err != nil {
			return errx.New(errors.New("Failed to exec user_ad_properties_insert"), errx.Fields{util.DBError: err})
		}
	}

	return nil
}
