package channels_test

import (
	"testing"

	"errors"

	. "code.justin.tv/web/users-service/backend/channels"
	"code.justin.tv/web/users-service/database/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type Result struct {
	Count int64
}

func (dr Result) RowsAffected() (int64, error) {
	return dr.Count, nil
}

func (dr Result) LastInsertId() (int64, error) {
	return 0, nil
}

type UpdateChannelAdTest struct {
	suite.Suite
	sdb     *mocks.Querier
	mdb     *mocks.Querier
	tx      *mocks.Tx
	backend Backend
	ctx     context.Context
	upProp  models.UpdateChannelProperties
}

func (suite *UpdateChannelAdTest) SetupTest() {
	var err error
	suite.sdb = &mocks.Querier{}
	suite.mdb = &mocks.Querier{}
	suite.tx = &mocks.Tx{}
	suite.backend, err = NewBackend(suite.sdb, suite.mdb)
	assert.NoError(suite.T(), err)
	suite.ctx = context.Background()
	suite.upProp = models.UpdateChannelProperties{
		ID:                Channels[AdminUserID].ID,
		BlockNonPublicAds: GetBoolPointer(true),
		FightAdBlock:      GetBoolPointer(true),
	}
}

func (suite *UpdateChannelAdTest) TestUpdateChannelAd() {
	suite.tx.Mock.On("Exec", mock.Anything, "user_ad_properties_update", SqlUpdateChannelAdProperties, []interface{}{suite.upProp.ID, suite.upProp.BlockNonPublicAds, suite.upProp.PrerollsDisabled, suite.upProp.PostrollsDisabled, suite.upProp.FightAdBlock}).Return(Result{1}, nil)

	err := UpdateChannelAdProperties(suite.ctx, suite.upProp, suite.tx)
	assert.NoError(suite.T(), err)
	suite.tx.AssertExpectations(suite.T())
}

func (suite *UpdateChannelAdTest) TestUpdateChannelAdDBError() {
	suite.tx.Mock.On("Exec", mock.Anything, "user_ad_properties_update", SqlUpdateChannelAdProperties, []interface{}{suite.upProp.ID, suite.upProp.BlockNonPublicAds, suite.upProp.PrerollsDisabled, suite.upProp.PostrollsDisabled, suite.upProp.FightAdBlock}).Return(Result{1}, errors.New(""))

	err := UpdateChannelAdProperties(suite.ctx, suite.upProp, suite.tx)
	assert.Error(suite.T(), err)
}

func TestUpdateChannelAdSuite(t *testing.T) {
	suite.Run(t, new(UpdateChannelAdTest))
}
