package channels

import (
	"golang.org/x/net/context"

	"errors"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/database"
	"code.justin.tv/web/users-service/models"
)

const (
	SqlBumpUsersUpdatedOn = `UPDATE "users" SET` +
		`  updated_on = LOCALTIMESTAMP` +
		` WHERE id = $1`

	SqlUpdateChannelBasicProperties = `UPDATE "users" SET` +
		` "directory_hidden" = $2,` +
		` "broadcaster" = $3,` +
		` "broadcaster_language" = $4,` +
		` "broadcaster_software" = $5,` +
		` "game" = $6,` +
		` "game_id" = $7,` +
		` "mature" = $8,` +
		` "status" = $9,` +
		` "title" = $10,` +
		` "views_count" = $11,` +
		` "updated_on" = LOCALTIMESTAMP` +
		` WHERE "id" = $1`
)

func UpdateChannelBasicProperties(ctx context.Context, updateProps models.UpdateChannelProperties, tx database.Tx) error {
	_, err := tx.Exec(
		ctx,
		"channel_properties_update",
		SqlUpdateChannelBasicProperties,
		updateProps.ID,
		updateProps.DirectoryHidden,
		updateProps.Broadcaster,
		updateProps.BroadcasterLanguage,
		updateProps.BroadcasterSoftware,
		updateProps.Game,
		updateProps.GameID,
		updateProps.Mature,
		updateProps.Status,
		updateProps.Title,
		updateProps.ViewsCount,
	)

	if err != nil {
		return errx.New(errors.New("Failed to exec channel_basic_properties_update"), errx.Fields{util.DBError: err})
	}

	return nil
}

func (c *channelPropertiesRepoImpl) bumpUserUpdatedOn(ctx context.Context, ID uint64) error {
	_, err := c.mdb.Exec(ctx,
		"bump_users_updated_on",
		SqlBumpUsersUpdatedOn,
		ID)

	return errx.New(err)
}
