package channels

import (
	"errors"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/database"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	SqlUpdateChannelBroadcastProperties = `UPDATE "user_broadcast_properties" SET` +
		` "last_broadcast_time" = $2,` +
		` "last_broadcast_id" = $3,` +
		` "last_live_notification_sent" = $4,` +
		` "updated_at" = LOCALTIMESTAMP` +
		` WHERE "user_id" = $1`

	SqlInsertChannelBroadcastProperties = `INSERT into user_broadcast_properties (user_id, last_broadcast_time, last_broadcast_id, last_live_notification_sent, created_at, updated_at)` +
		` VALUES ($1, $2, $3, $4, LOCALTIMESTAMP, LOCALTIMESTAMP)`
)

func UpdateChannelBroadcastProperties(ctx context.Context, updateProps models.UpdateChannelProperties, tx database.Tx) error {
	result, err := tx.Exec(
		ctx,
		"user_broadcast_properties_update",
		SqlUpdateChannelBroadcastProperties,
		updateProps.ID,
		updateProps.LastBroadcastTime,
		updateProps.LastBroadcastID,
		updateProps.LastLiveNotificationSent,
	)

	if err != nil {
		return errx.New(errors.New("Failed to exec user_broadcast_properties_update"), errx.Fields{util.DBError: err})
	}

	affected, err := result.RowsAffected()
	if err != nil {
		return errx.New(err)
	}
	if affected == 0 {
		_, err := tx.Exec(
			ctx,
			"user_broadcast_properties_insert",
			SqlInsertChannelBroadcastProperties,
			updateProps.ID,
			updateProps.LastBroadcastTime,
			updateProps.LastBroadcastID,
			updateProps.LastLiveNotificationSent,
		)

		if err != nil {
			return errx.New(errors.New("Failed to exec user_broadcast_properties_insert"), errx.Fields{util.DBError: err})
		}
	}

	return nil
}
