package channels_test

import (
	"testing"

	"errors"

	. "code.justin.tv/web/users-service/backend/channels"
	"code.justin.tv/web/users-service/database/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type UpdateChannelBroadcastTest struct {
	suite.Suite
	sdb     *mocks.Querier
	mdb     *mocks.Querier
	tx      *mocks.Tx
	backend Backend
	ctx     context.Context
	upProp  models.UpdateChannelProperties
}

func (suite *UpdateChannelBroadcastTest) SetupTest() {
	var err error
	suite.sdb = &mocks.Querier{}
	suite.mdb = &mocks.Querier{}
	suite.tx = &mocks.Tx{}
	suite.backend, err = NewBackend(suite.sdb, suite.mdb)
	assert.NoError(suite.T(), err)
	suite.ctx = context.Background()
	suite.upProp = models.UpdateChannelProperties{
		ID:              Channels[AdminUserID].ID,
		LastBroadcastID: GetStringPointer("123"),
	}
}

func (suite *UpdateChannelBroadcastTest) TestUpdateChannelBroadcast() {
	suite.tx.Mock.On("Exec", mock.Anything, "user_broadcast_properties_update", SqlUpdateChannelBroadcastProperties, []interface{}{suite.upProp.ID, suite.upProp.LastBroadcastTime, suite.upProp.LastBroadcastID, suite.upProp.LastLiveNotificationSent}).Return(Result{1}, nil)

	err := UpdateChannelBroadcastProperties(suite.ctx, suite.upProp, suite.tx)
	assert.NoError(suite.T(), err)
	suite.tx.AssertExpectations(suite.T())
}

func (suite *UpdateChannelBroadcastTest) TestUpdateChannelBroadcastDBError() {
	suite.tx.Mock.On("Exec", mock.Anything, "user_broadcast_properties_update", SqlUpdateChannelBroadcastProperties, []interface{}{suite.upProp.ID, suite.upProp.LastBroadcastTime, suite.upProp.LastBroadcastID, suite.upProp.LastLiveNotificationSent}).Return(Result{1}, errors.New(""))

	err := UpdateChannelBroadcastProperties(suite.ctx, suite.upProp, suite.tx)
	assert.Error(suite.T(), err)
}

func TestUpdateBroadcastSuite(t *testing.T) {
	suite.Run(t, new(UpdateChannelBroadcastTest))
}
