package channels

import (
	"errors"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/database"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	SqlUpdateChannelUserProperties = `UPDATE "user_channel_properties" SET` +
		` "about" = $2,` +
		` "redirect_channel" = $3,` +
		` "primary_team_id" = $4,` +
		` "disable_chat" = $5,` +
		` "updated_at" = LOCALTIMESTAMP` +
		` WHERE "user_id" = $1`

	SqlInsertChannelUserProperties = `INSERT into user_channel_properties (user_id, about, redirect_channel, primary_team_id, disable_chat, created_at, updated_at)` +
		` VALUES ($1, $2, $3, $4, $5, LOCALTIMESTAMP, LOCALTIMESTAMP)`
)

func UpdateChannelUserProperties(ctx context.Context, updateProps models.UpdateChannelProperties, tx database.Tx) error {
	result, err := tx.Exec(
		ctx,
		"user_channel_properties_update",
		SqlUpdateChannelUserProperties,
		updateProps.ID,
		updateProps.About,
		updateProps.RedirectChannel,
		updateProps.PrimaryTeamID,
		updateProps.DisableChat,
	)

	if err != nil {
		return errx.New(errors.New("Failed to exec user_channel_properties_update"), errx.Fields{util.DBError: err})
	}

	affected, err := result.RowsAffected()
	if err != nil {
		return errx.New(err)
	}
	if affected == 0 {
		_, err := tx.Exec(
			ctx,
			"user_channel_properties_insert",
			SqlInsertChannelUserProperties,
			updateProps.ID,
			updateProps.About,
			updateProps.RedirectChannel,
			updateProps.PrimaryTeamID,
			updateProps.DisableChat,
		)

		if err != nil {
			return errx.New(errors.New("Failed to exec user_channel_properties_insert"), errx.Fields{util.DBError: err})
		}
	}

	return nil
}
