package channels_test

import (
	"testing"

	"errors"

	. "code.justin.tv/web/users-service/backend/channels"
	"code.justin.tv/web/users-service/database/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type UpdateUserChannelTest struct {
	suite.Suite
	sdb     *mocks.Querier
	mdb     *mocks.Querier
	tx      *mocks.Tx
	backend Backend
	ctx     context.Context
	upProp  models.UpdateChannelProperties
}

func (suite *UpdateUserChannelTest) SetupTest() {
	var err error
	suite.sdb = &mocks.Querier{}
	suite.mdb = &mocks.Querier{}
	suite.tx = &mocks.Tx{}
	suite.backend, err = NewBackend(suite.sdb, suite.mdb)
	assert.NoError(suite.T(), err)
	suite.ctx = context.Background()
	suite.upProp = models.UpdateChannelProperties{
		ID:              Channels[AdminUserID].ID,
		About:           GetStringPointer("test"),
		RedirectChannel: nil,
		PrimaryTeamID:   nil,
		DisableChat:     GetBoolPointer(true),
	}
}

func (suite *UpdateUserChannelTest) TestUpdateUserChannel() {
	suite.tx.Mock.On("Exec", mock.Anything, "user_channel_properties_update", SqlUpdateChannelUserProperties, []interface{}{
		suite.upProp.ID, suite.upProp.About, suite.upProp.RedirectChannel, suite.upProp.PrimaryTeamID, suite.upProp.DisableChat,
	}).Return(Result{1}, nil)

	err := UpdateChannelUserProperties(suite.ctx, suite.upProp, suite.tx)
	assert.NoError(suite.T(), err)
	suite.tx.AssertExpectations(suite.T())
}

func (suite *UpdateUserChannelTest) TestUpdateUserChannelDBError() {
	suite.tx.Mock.On("Exec", mock.Anything, "user_channel_properties_update", SqlUpdateChannelUserProperties, []interface{}{
		suite.upProp.ID, suite.upProp.About, suite.upProp.RedirectChannel, suite.upProp.PrimaryTeamID, suite.upProp.DisableChat,
	}).Return(Result{1}, errors.New(""))

	err := UpdateChannelUserProperties(suite.ctx, suite.upProp, suite.tx)
	assert.Error(suite.T(), err)
}

func TestUpdateUserChannelSuite(t *testing.T) {
	suite.Run(t, new(UpdateUserChannelTest))
}
