package backend

import (
	"time"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/foundation/xray"
	"golang.org/x/net/context"
)

// DetachContext detaches a context and keeps sane defaults. The intended parameter is an http context although any context is acceptable.
func DetachContext(ctx context.Context) context.Context {
	// If the context contains xray information, keep it
	dCtx := xray.DetachContext(ctx)
	// Ensure the timeout can't run forever
	dCtx, _ = context.WithTimeout(dCtx, 10*time.Second)
	// Attach relevant fields from logx to detatched Context
	dCtx = logx.CopyFields(ctx, dCtx)

	return dCtx
}
