package mocks

import backend "code.justin.tv/web/users-service/backend"
import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/users-service/models"

// Cacher is an autogenerated mock type for the Cacher type
type Cacher struct {
	mock.Mock
}

// BulkGetProperties provides a mock function with given fields: ctx, field, key, e
func (_m *Cacher) BulkGetProperties(ctx context.Context, field string, key []string, e interface{}) ([]int, error) {
	ret := _m.Called(ctx, field, key, e)

	var r0 []int
	if rf, ok := ret.Get(0).(func(context.Context, string, []string, interface{}) []int); ok {
		r0 = rf(ctx, field, key, e)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, []string, interface{}) error); ok {
		r1 = rf(ctx, field, key, e)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BulkSetProperties provides a mock function with given fields: ctx, overwrite, iter
func (_m *Cacher) BulkSetProperties(ctx context.Context, overwrite bool, iter models.CacheableIterator) error {
	ret := _m.Called(ctx, overwrite, iter)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, bool, models.CacheableIterator) error); ok {
		r0 = rf(ctx, overwrite, iter)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CacheProperties provides a mock function with given fields: ctx, overwrite, props
func (_m *Cacher) CacheProperties(ctx context.Context, overwrite bool, props models.Cacheable) error {
	ret := _m.Called(ctx, overwrite, props)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, bool, models.Cacheable) error); ok {
		r0 = rf(ctx, overwrite, props)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Close provides a mock function with given fields:
func (_m *Cacher) Close() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ExpireProperties provides a mock function with given fields: ctx, prop
func (_m *Cacher) ExpireProperties(ctx context.Context, prop models.Cacheable) error {
	ret := _m.Called(ctx, prop)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, models.Cacheable) error); ok {
		r0 = rf(ctx, prop)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetProperties provides a mock function with given fields: ctx, field, key, e
func (_m *Cacher) GetProperties(ctx context.Context, field string, key string, e interface{}) error {
	ret := _m.Called(ctx, field, key, e)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, interface{}) error); ok {
		r0 = rf(ctx, field, key, e)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ backend.Cacher = (*Cacher)(nil)
