package backend

import (
	"context"
	"fmt"
	"strings"
	"time"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/common/config"
)

func ReportIdentifiers(ctx context.Context, identifier string, num int, err error) {
	if num == 0 {
		return
	}
	status := "success"
	if err != nil {
		status = "failure"
	}

	reportIdentifiers(ctx, identifier, status, num)
}

func reportIdentifiers(ctx context.Context, identifier, status string, num int) {
	statusMetric := fmt.Sprintf("requestidentifiers.%s.%s", identifier, status)
	totalMetric := "requestidentifiers.All"
	metrics := []string{statusMetric, totalMetric}
	for _, metric := range metrics {
		if metricsErr := config.Statsd().Inc(metric, int64(num), 0.1); metricsErr != nil {
			logx.Warn(ctx, fmt.Sprintf("failed to increment %s: %s", metric, metricsErr))
		}
	}
}

func ReportBulkIdentifiers(ctx context.Context, identifier string, num int, dur time.Duration, err error) {
	if num == 0 {
		return
	}
	status := "success"
	if err != nil {
		status = "failure"
	}

	reportIdentifiers(ctx, identifier, status, num)

	if strings.Contains(strings.ToLower(identifier), "bulk") {
		// Report bucket size
		bucket := getBucket(num)
		bucketMetric := fmt.Sprintf("requestidentifiers_bucket.%s.%s.%s", identifier, bucket, status)
		if metricsErr := config.Statsd().Inc(bucketMetric, 1, 0.1); metricsErr != nil {
			logx.Warn(ctx, fmt.Sprintf("failed to increment %s: %s", bucketMetric, metricsErr))
		}
		if metricsErr := config.Statsd().TimingDuration(bucketMetric, dur, 0.1); metricsErr != nil {
			logx.Warn(ctx, fmt.Sprintf("failed to time %s: %s", bucketMetric, metricsErr))
		}
	}
}

func getBucket(num int) string {
	zeroes := 0
	for ; num > 9; zeroes++ {
		num = num / 10
	}

	bucket := "1"
	for i := 0; i < zeroes; i++ {
		bucket = bucket + "0"
	}

	return bucket
}
