package backend

import "testing"

func TestGetBucket(t *testing.T) {
	for name, scenario := range map[string]struct {
		Num    int
		Bucket string
	}{
		"1": {
			Num:    5,
			Bucket: "1",
		},
		"10": {
			Num:    50,
			Bucket: "10",
		},
		"10-edge": {
			Num:    10,
			Bucket: "10",
		},
		"100": {
			Num:    500,
			Bucket: "100",
		},
		"1000": {
			Num:    5000,
			Bucket: "1000",
		},
	} {
		t.Run(name, func(t *testing.T) {
			bucket := getBucket(scenario.Num)
			if bucket != scenario.Bucket {
				t.Errorf("%s != %s", bucket, scenario.Bucket)
			}
		})
	}
}
