package reservations

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	sqlInsertReservations = ` INSERT into login_reservations (login, type, reason, expires_on) VALUES ($1, $2, $3, $4)`
)

func (c *reservationDBImpl) AddReservation(ctx context.Context, prop models.ReservationProperties) error {
	var err error
	if prop.ExpiresOn != nil {
		_, err = c.mdb.Exec(ctx, "add_reservation", sqlInsertReservations, prop.Login, prop.Type, prop.Reason, *prop.ExpiresOn)
	} else {
		_, err = c.mdb.Exec(ctx, "add_reservation", sqlInsertReservations, prop.Login, prop.Type, prop.Reason, nil)
	}

	return errx.New(err)
}
