package reservations

import (
	"code.justin.tv/web/users-service/database"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

//go:generate mockery -name Backend
//go:generate hystrixer Backend --metric Reservations --config config.yaml
type Backend interface {
	GetReservations(ctx context.Context, logins []string) ([]models.ReservationProperties, error)
	GetReservation(ctx context.Context, login string) (*models.ReservationProperties, error)
	AddReservation(ctx context.Context, prop models.ReservationProperties) error
	DeleteReservation(ctx context.Context, login string) error
	UpdateReservation(ctx context.Context, prop models.ReservationProperties) error
}

type reservationDBImpl struct {
	mdb database.Querier
	sdb database.Querier
}

func NewBackend(sdb database.Querier, mdb database.Querier) (Backend, error) {
	return &reservationDBImpl{
		sdb: sdb,
		mdb: mdb,
	}, nil
}
