package reservations

import (
	"code.justin.tv/chat/golibs/errx"
	"golang.org/x/net/context"
)

const (
	sqlDeleteReservation = `DELETE FROM login_reservations WHERE login = $1`
)

func (c *reservationDBImpl) DeleteReservation(ctx context.Context, login string) error {
	_, err := c.mdb.Exec(ctx, "delete_reservation", sqlDeleteReservation, login)
	return errx.New(err)
}
