package reservations

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	sqlUpdateReservations = `WITH upsert` +
		` AS (` +
		` UPDATE login_reservations` +
		` SET type = $2,` +
		` reason = $3,` +
		` expires_on=$4` +
		` WHERE login=$1` +
		` RETURNING *` +
		` )` +
		` INSERT into login_reservations (login, type, reason, expires_on) ` +
		` SELECT $1, $2, $3, $4` +
		` WHERE NOT EXISTS (SELECT * FROM upsert)`
)

func (c *reservationDBImpl) UpdateReservation(ctx context.Context, prop models.ReservationProperties) error {
	var err error
	if prop.ExpiresOn != nil {
		_, err = c.mdb.Exec(ctx, "update_reservation", sqlUpdateReservations, prop.Login, prop.Type, prop.Reason, *prop.ExpiresOn)
	} else {
		_, err = c.mdb.Exec(ctx, "update_reservation", sqlUpdateReservations, prop.Login, prop.Type, prop.Reason, nil)
	}

	return errx.New(err)
}
