package users

import (
	"time"

	"code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

//go:generate mockery -name Backend
type Backend interface {
	GetUserPropertiesByID(ctx context.Context, id string, opts util.ReadOptions) (*models.Properties, error)
	GetUserPropertiesByLogin(ctx context.Context, login string, opts util.ReadOptions) (*models.Properties, error)
	GetUserPropertiesByDisplayname(ctx context.Context, dn *string) (*models.Properties, error)
	GetUsersProperties(ctx context.Context, field string, identifiers []string) ([]models.Properties, error)
	GetUserPropertiesBulk(ctx context.Context, params *models.FilterParams) ([]models.Properties, error)
	GetUserPropertiesLike(ctx context.Context, field string, pattern string) ([]models.Properties, error)
	GetBannedUsers(ctx context.Context, until time.Time) ([]models.Properties, error)
	UpdateProperties(ctx context.Context, uup *models.UpdateableProperties, cup *models.Properties) error
	UnbanUser(ctx context.Context, id string, tosCount, dmcaCount int) error
	BanUser(ctx context.Context, id string, warn bool, tosBan bool, dmcaStrikes int, tosStrikes int) error
	AlterDMCAStrike(ctx context.Context, id string, delta int) error
	GetUserBlock(ctx context.Context, login string) (*models.BlockProperties, error)
	GetUserImages(ctx context.Context, id string, login string) (*models.ImageProperties, error)
	CreateUser(ctx context.Context, up *models.CreateUserProperties) error
	CreateUserEmail(ctx context.Context, id, code string) error
	GetUserPhoneNumber(ctx context.Context, id string) (*models.PhoneNumberProperties, error)
	VerifyUserPhoneNumber(ctx context.Context, id string) error
	GetGlobalPrivilegedUsers(ctx context.Context, roles []string) (*models.GlobalPrivilegedUsers, error)
	GetLogins(ctx context.Context, logins []string) ([]models.LoginProperties, error)
	SetUserImageProperties(ctx context.Context, updates models.ImageProperties) error
	HardDeleteUser(ctx context.Context, ID string, skipBlock bool) (*models.Properties, error)
	SoftDeleteUser(ctx context.Context, ID string) error
	UndeleteUser(ctx context.Context, ID string) error
}

//go:generate mockery -name CacheBackend
type CacheBackend interface {
	GetUserProperties(ctx context.Context, field string, key string) (*models.Properties, error)
	GetUsersProperties(ctx context.Context, field string, identifiers []string) ([]models.Properties, []int, error)
	ExpireUserProperties(ctx context.Context, prop *models.Properties) error
	CacheUsersProperties(ctx context.Context, props []models.Properties, overwrite bool) error
}
