package cache

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/internal/utils"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

func (c *CacheBackendImpl) ExpireUserProperties(ctx context.Context, prop *models.Properties) error {
	err := c.cacher.ExpireProperties(ctx, prop)
	if utils.IsKnownErr(err) {
		return err
	}

	return errx.New(err)
}
