package cache

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

func (c *CacheBackendImpl) GetUserProperties(ctx context.Context, field, key string) (*models.Properties, error) {

	props := &models.Properties{}
	err := c.cacher.GetProperties(ctx, field, key, props)
	if backend.IsCacheMissErr(err) {
		return nil, nil
	}

	return props, errx.New(err)
}

func (c *CacheBackendImpl) GetUsersProperties(ctx context.Context, field string, identifiers []string) ([]models.Properties, []int, error) {
	var props []models.Properties
	missingIndexes, err := c.cacher.BulkGetProperties(ctx, field, identifiers, &props)

	return props, missingIndexes, errx.New(err)
}
