package db

import (
	"time"

	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	sqlSelectBannedUsers = sqlSelectPropertiesWherePartial + " banned_until < $1"
)

func (c *siteDBImpl) GetBannedUsers(ctx context.Context, until time.Time) ([]models.Properties, error) {

	rows, err := c.sdb.Query(ctx, "users_banned_until", sqlSelectBannedUsers, until)
	ups, err := GetUserPropertiesFromRows(rows)

	return ups, err
}
