package db

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend"
	. "code.justin.tv/web/users-service/backend/util"
	"golang.org/x/net/context"
)

const (
	sqlBanGetUMPProps = `SELECT * from user_moderation_properties where user_id = $1`

	sqlBanSetUMPProps = `WITH upsert` +
		` AS (` +
		` UPDATE user_moderation_properties` +
		` SET banned_until = ` +
		` CASE WHEN $2 THEN ` +
		` LOCALTIMESTAMP + INTERVAL '1 day'` +
		` ELSE ` +
		` null` +
		` END` +
		` ,` +
		` dmca_violation_count = ` +
		` CASE WHEN NOT $3 THEN` +
		` $4` +
		` ELSE` +
		` dmca_violation_count` +
		` END` +
		` ,` +
		` tos_violation_count = ` +
		` CASE WHEN $3 THEN` +
		` $5` +
		` ELSE` +
		` tos_violation_count` +
		` END` +
		` ,` +
		` updated_at = LOCALTIMESTAMP` +
		` WHERE user_id = $1` +
		` RETURNING *` +
		` )` +
		` INSERT INTO user_moderation_properties (user_id, banned_until, dmca_violation_count, tos_violation_count, created_at, updated_at)` +
		` SELECT` +
		` $1,` +
		` CASE WHEN $2 THEN LOCALTIMESTAMP + INTERVAL '1 day' ELSE null END,` +
		` CASE WHEN NOT $3 THEN $4 ELSE null END,` +
		` CASE WHEN $3 THEN $5 ELSE null END,` +
		` LOCALTIMESTAMP,` +
		` LOCALTIMESTAMP` +
		` WHERE NOT EXISTS (SELECT * FROM upsert)`

	sqlBanSetUsersProps = `UPDATE users` +
		` SET terms_of_service_violation = $2,` +
		` dmca_violation = NOT $2,` +
		` updated_on = now()` +
		` where id = $1`
)

func (c *siteDBImpl) BanUser(ctx context.Context, ID string, warn bool, tosBan bool, dmcaStrikes int, tosStrikes int) error {
	tx, err := backend.OpenTx(ctx, c.mdb, "ban user")
	if err != nil {
		return err
	}
	defer func() {
		tx.Close(ctx, err)
	}()

	if _, err := tx.Exec(ctx, "ban_set_ump_properties", sqlBanSetUMPProps, ID, warn, tosBan, dmcaStrikes, tosStrikes); err != nil {
		return errx.New(err, errx.Fields{DBError: "Error setting UMP propertie"})
	}

	if _, err := tx.Exec(ctx, "ban_set_users_properties", sqlBanSetUsersProps, ID, tosBan); err != nil {
		return errx.New(err, errx.Fields{DBError: "Error setting Users properties"})
	}

	return errx.New(err)
}
