package db

import (
	"testing"

	"code.justin.tv/web/users-service/database/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type BanUserTest struct {
	suite.Suite
	sdb *mocks.Querier
	mdb *mocks.Querier
	tx  mocks.Tx
	ctx context.Context
}

func (suite *BanUserTest) SetupTest() {
	suite.sdb = &mocks.Querier{}
	suite.mdb = &mocks.Querier{}
	suite.tx = mocks.Tx{}
	suite.ctx = context.Background()
}

func (suite *CreateUserTest) TestSuccessBanUser() {
	ub := &siteDBImpl{sdb: suite.sdb, mdb: suite.mdb}
	ID := Users[ToBanUserID].ID

	suite.tx.On("Commit").Return(nil)
	suite.tx.On("Exec", suite.ctx, "ban_set_ump_properties", sqlBanSetUMPProps, []interface{}{
		ID,
		true,
		true,
		0,
		1,
	}).Return(&mocks.Result{}, nil)
	suite.tx.On("Exec", suite.ctx, "ban_set_users_properties", sqlBanSetUsersProps, []interface{}{
		ID,
		true,
	}).Return(&mocks.Result{}, nil)

	suite.mdb.On("Begin", suite.ctx, "ban_user_transaction").Return(&suite.tx, nil)

	err := ub.BanUser(suite.ctx, ID, true, true, 0, 1)
	assert.NoError(suite.T(), err)
}

func TestBanUserSuite(t *testing.T) {
	suite.Run(t, new(BanUserTest))
}
