package db

import (
	"strings"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend"
	. "code.justin.tv/web/users-service/backend/util"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	sqlCreateUser = `INSERT into users (login, displayname, birthday, email, language, category, remote_ip, location, updated_on, created_on, last_login_change_date)` +
		` VALUES ($1, $2, $3, $4, $5, $6, $7, $8, LOCALTIMESTAMP, LOCALTIMESTAMP, LOCALTIMESTAMP)`
)

func (c *siteDBImpl) CreateUser(ctx context.Context, up *models.CreateUserProperties) error {
	tx, err := backend.OpenTx(ctx, c.mdb, "create user")
	if err != nil {
		return err
	}
	defer func() {
		tx.Close(ctx, err)
	}()

	if _, err = tx.Exec(ctx, "create_user", sqlCreateUser, strings.ToLower(up.Login), up.Displayname, up.Birthday.ToDate(), up.Email, up.Language, up.Category, up.IP, up.Location); err != nil {
		return errx.New(err, errx.Fields{DBError: "Error creating new user"})
	}

	return nil
}
