package db

import (
	"strings"
	"testing"

	"code.justin.tv/web/users-service/database/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type CreateUserTest struct {
	suite.Suite
	sdb *mocks.Querier
	mdb *mocks.Querier
	tx  mocks.Tx
	ctx context.Context
}

func (suite *CreateUserTest) SetupTest() {
	suite.sdb = &mocks.Querier{}
	suite.mdb = &mocks.Querier{}
	suite.tx = mocks.Tx{}
	suite.ctx = context.Background()
}

func (suite *CreateUserTest) TestSuccessCreateUser() {
	ub := &siteDBImpl{sdb: suite.sdb, mdb: suite.mdb}
	prop := &models.CreateUserProperties{
		Login:    *Users[AdminUserID].Login,
		IP:       "",
		Birthday: GetBirthday(AdminUserID),
		Email:    *Users[AdminUserID].Email,
		Language: *Users[AdminUserID].Language,
	}

	suite.tx.On("Commit").Return(nil)
	suite.tx.On("Exec", suite.ctx, "create_user", sqlCreateUser, []interface{}{
		strings.ToLower(prop.Login),
		prop.Displayname,
		prop.Birthday.ToDate(),
		prop.Email,
		prop.Language,
		prop.Category,
		prop.IP,
		prop.Location,
	}).Return(&mocks.Result{}, nil)
	suite.mdb.On("Begin", suite.ctx, "create_user_transaction").Return(&suite.tx, nil)

	err := ub.CreateUser(suite.ctx, prop)
	assert.NoError(suite.T(), err)
}

func TestCreateUserSuite(t *testing.T) {
	suite.Run(t, new(CreateUserTest))
}
