package db

import (
	"database/sql"

	cdb "code.justin.tv/chat/db"
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/models"
	"golang.org/x/net/context"
)

const (
	sqlSelectUserBlock = `SELECT` +
		` u.id,` +
		` login,` +
		` renamed_login_block_record` +
		` FROM users u` +
		` WHERE "login" = $1`
)

func (c *siteDBImpl) GetUserBlock(ctx context.Context, login string) (*models.BlockProperties, error) {
	row := c.mdb.QueryRow(ctx, "user_block", sqlSelectUserBlock, login)

	dbResults, err := GetBlockPropertiesFromRow(row)
	if err != nil {
		return nil, err
	}

	return dbResults, nil
}

func GetBlockPropertiesFromRow(row cdb.Row) (*models.BlockProperties, error) {
	up := models.BlockProperties{}

	err := row.Scan(
		&up.ID,
		&up.Login,
		&up.RenamedLoginBlockRecord,
	)

	switch {
	case err == sql.ErrNoRows:
		return nil, nil
	case err != nil:
		return nil, errx.New(err)
	default:
	}

	return &up, nil
}
