package db

import (
	"code.justin.tv/chat/golibs/errx"
	"golang.org/x/net/context"

	"code.justin.tv/web/users-service/backend"
	"code.justin.tv/web/users-service/backend/util"
)

const (
	sqlCreateUserEmailProperties = `INSERT into user_email_properties (user_id, email_verification_code, email_verification_code_time, created_at, updated_at)` +
		` VALUES ($1, $2, LOCALTIMESTAMP, LOCALTIMESTAMP, LOCALTIMESTAMP)`
)

func (c *siteDBImpl) CreateUserEmail(ctx context.Context, id, code string) error {
	tx, err := backend.OpenTx(ctx, c.mdb, "create user email")
	if err != nil {
		return err
	}
	defer func() {
		tx.Close(ctx, err)
	}()

	if _, err := tx.Exec(ctx, "create_user_email", sqlCreateUserEmailProperties, id, code); err != nil {
		return errx.New(err, errx.Fields{util.DBError: "Error creating new user email property"})
	}

	return nil
}
