package db

import (
	"testing"

	"code.justin.tv/web/users-service/database/mocks"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

type SetImageTest struct {
	suite.Suite
	sdb *mocks.Querier
	mdb *mocks.Querier
	tx  mocks.Tx
	ctx context.Context
}

func (suite *SetImageTest) SetupTest() {
	suite.sdb = &mocks.Querier{}
	suite.mdb = &mocks.Querier{}
	suite.tx = mocks.Tx{}
	suite.ctx = context.Background()
}

func (suite *SetImageTest) TestSuccessSetImage() {
	ub := &siteDBImpl{sdb: suite.sdb, mdb: suite.mdb}
	updates := models.ImageProperties{
		ID:           AdminUserID,
		ProfileImage: Users[AdminUserID].ProfileImage,
	}

	result := mocks.Result{}
	result.On("RowsAffected").Return(int64(1), nil)
	suite.tx.On("Commit").Return(nil)
	suite.tx.On("Exec", suite.ctx, "user_image_properties_update", SqlUpdateUserImageProperties, mock.Anything).Return(&result, nil)
	suite.tx.On("Exec", suite.ctx, "user_image_properties_update", SqlUpdateProfileImage, mock.Anything).Return(&result, nil)
	suite.mdb.On("Begin", suite.ctx, "set_user_image_properties_transaction").Return(&suite.tx, nil)

	err := ub.SetUserImageProperties(suite.ctx, updates)
	assert.NoError(suite.T(), err)
	suite.tx.AssertExpectations(suite.T())
	suite.mdb.AssertExpectations(suite.T())
}

func TestSetImageSuite(t *testing.T) {
	suite.Run(t, new(SetImageTest))
}
