package db

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/web/users-service/backend"
	. "code.justin.tv/web/users-service/backend/util"
	"golang.org/x/net/context"
)

const (
	sqlUnbanSetUMPProps = `UPDATE user_moderation_properties ` +
		` SET banned_until = NULL,` +
		` dmca_violation_count = $2,` +
		` tos_violation_count = $3,` +
		` updated_at = now()` +
		` where user_id = $1`
	sqlUnbanSetUsersProps = `UPDATE users` +
		` SET terms_of_service_violation = false,` +
		` dmca_violation = false,` +
		` updated_on = now()` +
		` where id = $1`
)

func (c *siteDBImpl) UnbanUser(ctx context.Context, id string, tosCount, dmcaCount int) error {
	tx, err := backend.OpenTx(ctx, c.mdb, "unban user")
	if err != nil {
		return err
	}
	defer func() {
		tx.Close(ctx, err)
	}()

	if _, err := tx.Exec(ctx, "unban_set_ump_properties", sqlUnbanSetUMPProps, id, dmcaCount, tosCount); err != nil {
		return errx.New(err, errx.Fields{DBError: "Error setting UMP properties"})
	}

	if _, err := tx.Exec(ctx, "unban_set_users_properties", sqlUnbanSetUsersProps, id); err != nil {
		return errx.New(err, errx.Fields{DBError: "Error setting Users properties"})
	}

	return err
}
